/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryQueue;
import com.facebook.presto.execution.QueryQueueDefinition;
import com.facebook.presto.execution.QueryQueueManager;
import com.facebook.presto.execution.QueuedExecution;
import com.facebook.presto.execution.SqlQueryManagerStats;
import com.facebook.presto.execution.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

@ThreadSafe
public class SqlQueryQueueManager
implements QueryQueueManager {
    private final ConcurrentMap<QueueKey, QueryQueue> queryQueues = new ConcurrentHashMap<QueueKey, QueryQueue>();
    private final List<ResourceGroupSelector> selectors;
    private final MBeanExporter mbeanExporter;

    @Inject
    public SqlQueryQueueManager(List<? extends ResourceGroupSelector> selectors, MBeanExporter mbeanExporter) {
        this.mbeanExporter = Objects.requireNonNull(mbeanExporter, "mbeanExporter is null");
        this.selectors = ImmutableList.copyOf(selectors);
    }

    @Override
    public boolean submit(Statement statement, QueryExecution queryExecution, Executor executor, SqlQueryManagerStats stats) {
        List<QueryQueue> queues = this.selectQueues(statement, queryExecution.getSession(), executor);
        for (QueryQueue queue : queues) {
            if (queue.reserve(queryExecution)) continue;
            return false;
        }
        queues.get(0).enqueue(QueuedExecution.createQueuedExecution(queryExecution, queues.subList(1, queues.size()), executor, stats));
        return true;
    }

    private List<QueryQueue> selectQueues(Statement statement, Session session, Executor executor) {
        for (ResourceGroupSelector selector : this.selectors) {
            Optional<List<QueryQueueDefinition>> queues = selector.match(statement, session.toSessionRepresentation());
            if (!queues.isPresent()) continue;
            return this.getOrCreateQueues(session, executor, queues.get());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_ERROR, "Query did not match any queuing rule");
    }

    private List<QueryQueue> getOrCreateQueues(Session session, Executor executor, List<QueryQueueDefinition> definitions) {
        ImmutableList.Builder queues = ImmutableList.builder();
        for (QueryQueueDefinition definition : definitions) {
            QueryQueue queue;
            String expandedName;
            QueueKey key = new QueueKey(definition, expandedName = definition.getExpandedTemplate(session));
            if (!this.queryQueues.containsKey(key) && this.queryQueues.putIfAbsent(key, queue = new QueryQueue(executor, definition.getMaxQueued(), definition.getMaxConcurrent())) == null) {
                String objectName = ObjectNames.builder(QueryQueue.class, (String)definition.getTemplate()).withProperty("expansion", expandedName).build();
                this.mbeanExporter.export(objectName, (Object)queue);
            }
            queues.add(this.queryQueues.get(key));
        }
        return queues.build();
    }

    @PreDestroy
    public void destroy() {
        for (QueueKey key : this.queryQueues.keySet()) {
            String objectName = ObjectNames.builder(QueryQueue.class, (String)key.getQueue().getTemplate()).withProperty("expansion", key.getName()).build();
            this.mbeanExporter.unexport(objectName);
        }
    }

    private static class QueueKey {
        private final QueryQueueDefinition queue;
        private final String name;

        private QueueKey(QueryQueueDefinition queue, String name) {
            this.queue = Objects.requireNonNull(queue, "queue is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public QueryQueueDefinition getQueue() {
            return this.queue;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            QueueKey queueKey = (QueueKey)other;
            return Objects.equals(this.name, queueKey.name) && Objects.equals(this.queue.getTemplate(), queueKey.queue.getTemplate());
        }

        public int hashCode() {
            return Objects.hash(this.queue.getTemplate(), this.name);
        }
    }
}

