/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStateMachine;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.metadata.RemoteTransactionHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.split.RemoteSplit;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.airlift.concurrent.MoreFutures;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SqlStageExecution {
    private final StageStateMachine stateMachine;
    private final RemoteTaskFactory remoteTaskFactory;
    private final NodeTaskMap nodeTaskMap;
    private final boolean summarizeTaskInfo;
    private final Map<PlanFragmentId, RemoteSourceNode> exchangeSources;
    private final Map<Node, Set<RemoteTask>> tasks = new ConcurrentHashMap<Node, Set<RemoteTask>>();
    private final AtomicInteger nextTaskId = new AtomicInteger();
    private final Set<TaskId> allTasks = Sets.newConcurrentHashSet();
    private final Set<TaskId> finishedTasks = Sets.newConcurrentHashSet();
    private final Multimap<PlanNodeId, URI> exchangeLocations = HashMultimap.create();
    private final Set<PlanNodeId> completeSources = Sets.newConcurrentHashSet();
    private final Set<PlanFragmentId> completeSourceFragments = Sets.newConcurrentHashSet();
    private final AtomicReference<OutputBuffers> outputBuffers = new AtomicReference<OutputBuffers>(OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS);

    public SqlStageExecution(StageId stageId, URI location, PlanFragment fragment, RemoteTaskFactory remoteTaskFactory, Session session, boolean summarizeTaskInfo, NodeTaskMap nodeTaskMap, ExecutorService executor) {
        this(new StageStateMachine(Objects.requireNonNull(stageId, "stageId is null"), Objects.requireNonNull(location, "location is null"), Objects.requireNonNull(session, "session is null"), Objects.requireNonNull(fragment, "fragment is null"), Objects.requireNonNull(executor, "executor is null")), remoteTaskFactory, nodeTaskMap, summarizeTaskInfo);
    }

    public SqlStageExecution(StageStateMachine stateMachine, RemoteTaskFactory remoteTaskFactory, NodeTaskMap nodeTaskMap, boolean summarizeTaskInfo) {
        this.stateMachine = stateMachine;
        this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.summarizeTaskInfo = summarizeTaskInfo;
        ImmutableMap.Builder fragmentToExchangeSource = ImmutableMap.builder();
        for (RemoteSourceNode remoteSourceNode : stateMachine.getFragment().getRemoteSourceNodes()) {
            for (PlanFragmentId planFragmentId : remoteSourceNode.getSourceFragmentIds()) {
                fragmentToExchangeSource.put((Object)planFragmentId, (Object)remoteSourceNode);
            }
        }
        this.exchangeSources = fragmentToExchangeSource.build();
    }

    public StageId getStageId() {
        return this.stateMachine.getStageId();
    }

    public StageState getState() {
        return this.stateMachine.getState();
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<StageState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener::stateChanged);
    }

    public PlanFragment getFragment() {
        return this.stateMachine.getFragment();
    }

    public void beginScheduling() {
        this.stateMachine.transitionToScheduling();
    }

    public synchronized void transitionToSchedulingSplits() {
        this.stateMachine.transitionToSchedulingSplits();
    }

    public synchronized void schedulingComplete() {
        PlanNodeId partitionedSource;
        if (!this.stateMachine.transitionToScheduled()) {
            return;
        }
        if (this.getAllTasks().stream().anyMatch(task -> this.getState() == StageState.RUNNING)) {
            this.stateMachine.transitionToRunning();
        }
        if (this.finishedTasks.containsAll(this.allTasks)) {
            this.stateMachine.transitionToFinished();
        }
        if ((partitionedSource = this.stateMachine.getFragment().getPartitionedSource()) != null) {
            for (RemoteTask task2 : this.getAllTasks()) {
                task2.noMoreSplits(partitionedSource);
            }
            this.completeSources.add(partitionedSource);
        }
    }

    public synchronized void cancel() {
        this.stateMachine.transitionToCanceled();
        this.getAllTasks().forEach(RemoteTask::cancel);
    }

    public synchronized void abort() {
        this.stateMachine.transitionToAborted();
        this.getAllTasks().forEach(RemoteTask::abort);
    }

    public synchronized long getMemoryReservation() {
        return this.getAllTasks().stream().mapToLong(task -> task.getTaskInfo().getStats().getMemoryReservation().toBytes()).sum();
    }

    public synchronized Duration getTotalCpuTime() {
        long millis = this.getAllTasks().stream().mapToLong(task -> task.getTaskInfo().getStats().getTotalCpuTime().toMillis()).sum();
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }

    public StageInfo getStageInfo() {
        return this.stateMachine.getStageInfo(() -> this.getAllTasks().stream().map(RemoteTask::getTaskInfo).collect(ImmutableCollectors.toImmutableList()), ImmutableList::of);
    }

    public synchronized void addExchangeLocations(PlanFragmentId fragmentId, Set<URI> exchangeLocations, boolean noMoreExchangeLocations) {
        Objects.requireNonNull(fragmentId, "fragmentId is null");
        Objects.requireNonNull(exchangeLocations, "exchangeLocations is null");
        RemoteSourceNode remoteSource = this.exchangeSources.get(fragmentId);
        Preconditions.checkArgument((remoteSource != null ? 1 : 0) != 0, (String)"Unknown remote source %s. Known sources are %s", (Object[])new Object[]{fragmentId, this.exchangeSources.keySet()});
        this.exchangeLocations.putAll((Object)remoteSource.getId(), exchangeLocations);
        for (RemoteTask task : this.getAllTasks()) {
            ImmutableMultimap.Builder newSplits = ImmutableMultimap.builder();
            for (URI exchangeLocation : exchangeLocations) {
                newSplits.put((Object)remoteSource.getId(), (Object)SqlStageExecution.createRemoteSplitFor(task.getTaskInfo().getTaskId(), exchangeLocation));
            }
            task.addSplits((Multimap<PlanNodeId, Split>)newSplits.build());
        }
        if (noMoreExchangeLocations) {
            this.completeSourceFragments.add(fragmentId);
            if (this.completeSourceFragments.containsAll(remoteSource.getSourceFragmentIds())) {
                this.completeSources.add(remoteSource.getId());
                for (RemoteTask task : this.getAllTasks()) {
                    task.noMoreSplits(remoteSource.getId());
                }
            }
        }
    }

    public synchronized void setOutputBuffers(OutputBuffers outputBuffers) {
        OutputBuffers currentOutputBuffers;
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        do {
            currentOutputBuffers = this.outputBuffers.get();
            if (outputBuffers.getVersion() <= currentOutputBuffers.getVersion()) {
                return;
            }
            currentOutputBuffers.checkValidTransition(outputBuffers);
        } while (!this.outputBuffers.compareAndSet(currentOutputBuffers, outputBuffers));
        for (RemoteTask task : this.getAllTasks()) {
            task.setOutputBuffers(outputBuffers);
        }
    }

    public boolean hasTasks() {
        return !this.tasks.isEmpty();
    }

    public List<RemoteTask> getAllTasks() {
        return (List)this.tasks.values().stream().flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableList());
    }

    public synchronized CompletableFuture<?> getTaskStateChange() {
        List<RemoteTask> allTasks = this.getAllTasks();
        if (allTasks.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        List stateChangeFutures = (List)allTasks.stream().map(task -> task.getStateChange(task.getTaskInfo())).collect(ImmutableCollectors.toImmutableList());
        return MoreFutures.firstCompletedFuture((Iterable)stateChangeFutures, (boolean)true);
    }

    public synchronized RemoteTask scheduleTask(Node node, int partition) {
        Objects.requireNonNull(node, "node is null");
        return this.scheduleTask(node, partition, null, (Iterable<Split>)ImmutableList.of());
    }

    public synchronized Set<RemoteTask> scheduleSplits(Node node, int partition, Iterable<Split> splits) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(splits, "splits is null");
        PlanNodeId partitionedSource = this.stateMachine.getFragment().getPartitionedSource();
        Preconditions.checkState((partitionedSource != null ? 1 : 0) != 0, (Object)"Partitioned source is null");
        ImmutableSet.Builder newTasks = ImmutableSet.builder();
        Collection tasks = this.tasks.get(node);
        if (tasks == null) {
            newTasks.add((Object)this.scheduleTask(node, partition, partitionedSource, splits));
        } else {
            RemoteTask task = (RemoteTask)tasks.iterator().next();
            task.addSplits((Multimap<PlanNodeId, Split>)ImmutableMultimap.builder().putAll((Object)partitionedSource, splits).build());
        }
        return newTasks.build();
    }

    private synchronized RemoteTask scheduleTask(Node node, int partition, PlanNodeId sourceId, Iterable<Split> sourceSplits) {
        TaskId taskId = new TaskId(this.stateMachine.getStageId(), String.valueOf(this.nextTaskId.getAndIncrement()));
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        for (Split sourceSplit : sourceSplits) {
            initialSplits.put((Object)sourceId, (Object)sourceSplit);
        }
        for (Map.Entry entry : this.exchangeLocations.entries()) {
            initialSplits.put(entry.getKey(), (Object)SqlStageExecution.createRemoteSplitFor(taskId, (URI)entry.getValue()));
        }
        RemoteTask task = this.remoteTaskFactory.createRemoteTask(this.stateMachine.getSession(), taskId, node, partition, this.stateMachine.getFragment(), (Multimap<PlanNodeId, Split>)initialSplits.build(), this.outputBuffers.get(), this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId), this.summarizeTaskInfo);
        this.completeSources.forEach(task::noMoreSplits);
        this.allTasks.add(taskId);
        this.tasks.computeIfAbsent(node, key -> Sets.newConcurrentHashSet()).add(task);
        this.nodeTaskMap.addTask(node, task);
        task.addStateChangeListener(new StageTaskListener());
        if (!this.stateMachine.getState().isDone()) {
            task.start();
        } else {
            task.abort();
        }
        return task;
    }

    public Set<Node> getScheduledNodes() {
        return ImmutableSet.copyOf(this.tasks.keySet());
    }

    public void recordGetSplitTime(long start) {
        this.stateMachine.recordGetSplitTime(start);
    }

    private static Split createRemoteSplitFor(TaskId taskId, URI taskLocation) {
        URI splitLocation = HttpUriBuilder.uriBuilderFrom((URI)taskLocation).appendPath("results").appendPath(taskId.toString()).build();
        return new Split("remote", new RemoteTransactionHandle(), new RemoteSplit(splitLocation));
    }

    public String toString() {
        return this.stateMachine.toString();
    }

    private class StageTaskListener
    implements StateMachine.StateChangeListener<TaskInfo> {
        private long previousMemory;

        private StageTaskListener() {
        }

        @Override
        public void stateChanged(TaskInfo taskInfo) {
            this.updateMemoryUsage(taskInfo);
            StageState stageState = SqlStageExecution.this.getState();
            if (stageState.isDone()) {
                return;
            }
            TaskState taskState = taskInfo.getState();
            if (taskState == TaskState.FAILED) {
                RuntimeException failure = taskInfo.getFailures().stream().findFirst().map(ExecutionFailureInfo::toException).orElse((RuntimeException)((Object)new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "A task failed for an unknown reason")));
                SqlStageExecution.this.stateMachine.transitionToFailed(failure);
            } else if (taskState == TaskState.ABORTED) {
                SqlStageExecution.this.stateMachine.transitionToFailed(new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "A task is in the ABORTED state but stage is " + (Object)((Object)stageState)));
            } else if (taskState == TaskState.FINISHED) {
                SqlStageExecution.this.finishedTasks.add(taskInfo.getTaskId());
            }
            if (stageState == StageState.SCHEDULED || stageState == StageState.RUNNING) {
                if (taskState == TaskState.RUNNING) {
                    SqlStageExecution.this.stateMachine.transitionToRunning();
                }
                if (SqlStageExecution.this.finishedTasks.containsAll(SqlStageExecution.this.allTasks)) {
                    SqlStageExecution.this.stateMachine.transitionToFinished();
                }
            }
        }

        private synchronized void updateMemoryUsage(TaskInfo taskInfo) {
            long currentMemory = taskInfo.getStats().getMemoryReservation().toBytes();
            long deltaMemoryInBytes = currentMemory - this.previousMemory;
            this.previousMemory = currentMemory;
            SqlStageExecution.this.stateMachine.updateMemoryUsage(deltaMemoryInBytes);
        }
    }
}

