/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"experimental.big-query-max-task-memory", "task.max-memory", "task.http-notification-threads"})
public class TaskManagerConfig {
    private boolean verboseStats;
    private boolean taskCpuTimerEnabled = true;
    private DataSize maxPartialAggregationMemoryUsage = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize operatorPreAllocatedMemory = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize maxIndexMemoryUsage = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private boolean shareIndexLoading;
    private int maxWorkerThreads = Runtime.getRuntime().availableProcessors() * 4;
    private Integer minDrivers;
    private Integer initialSplitsPerNode;
    private Duration splitConcurrencyAdjustmentInterval = new Duration(100.0, TimeUnit.MILLISECONDS);
    private DataSize sinkMaxBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private DataSize maxPagePartitioningBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private Duration clientTimeout = new Duration(2.0, TimeUnit.MINUTES);
    private Duration infoMaxAge = new Duration(15.0, TimeUnit.MINUTES);
    private Duration infoRefreshMaxWait = new Duration(200.0, TimeUnit.MILLISECONDS);
    private int writerCount = 1;
    private int taskDefaultConcurrency = 1;
    private Integer taskJoinConcurrency;
    private int httpResponseThreads = 100;
    private int httpTimeoutThreads = 3;
    private int taskNotificationThreads = 5;

    @MinDuration(value="1ms")
    @MaxDuration(value="10s")
    @NotNull
    public Duration getInfoRefreshMaxWait() {
        return this.infoRefreshMaxWait;
    }

    @Config(value="task.info-refresh-max-wait")
    public TaskManagerConfig setInfoRefreshMaxWait(Duration infoRefreshMaxWait) {
        this.infoRefreshMaxWait = infoRefreshMaxWait;
        return this;
    }

    public boolean isVerboseStats() {
        return this.verboseStats;
    }

    @Config(value="task.verbose-stats")
    public TaskManagerConfig setVerboseStats(boolean verboseStats) {
        this.verboseStats = verboseStats;
        return this;
    }

    public boolean isTaskCpuTimerEnabled() {
        return this.taskCpuTimerEnabled;
    }

    @Config(value="task.cpu-timer-enabled")
    public TaskManagerConfig setTaskCpuTimerEnabled(boolean taskCpuTimerEnabled) {
        this.taskCpuTimerEnabled = taskCpuTimerEnabled;
        return this;
    }

    @NotNull
    public DataSize getMaxPartialAggregationMemoryUsage() {
        return this.maxPartialAggregationMemoryUsage;
    }

    @Config(value="task.max-partial-aggregation-memory")
    public TaskManagerConfig setMaxPartialAggregationMemoryUsage(DataSize maxPartialAggregationMemoryUsage) {
        this.maxPartialAggregationMemoryUsage = maxPartialAggregationMemoryUsage;
        return this;
    }

    @NotNull
    public DataSize getOperatorPreAllocatedMemory() {
        return this.operatorPreAllocatedMemory;
    }

    @Config(value="task.operator-pre-allocated-memory")
    public TaskManagerConfig setOperatorPreAllocatedMemory(DataSize operatorPreAllocatedMemory) {
        this.operatorPreAllocatedMemory = operatorPreAllocatedMemory;
        return this;
    }

    @NotNull
    public DataSize getMaxIndexMemoryUsage() {
        return this.maxIndexMemoryUsage;
    }

    @Config(value="task.max-index-memory")
    public TaskManagerConfig setMaxIndexMemoryUsage(DataSize maxIndexMemoryUsage) {
        this.maxIndexMemoryUsage = maxIndexMemoryUsage;
        return this;
    }

    @NotNull
    public boolean isShareIndexLoading() {
        return this.shareIndexLoading;
    }

    @Config(value="task.share-index-loading")
    public TaskManagerConfig setShareIndexLoading(boolean shareIndexLoading) {
        this.shareIndexLoading = shareIndexLoading;
        return this;
    }

    @Min(value=1L)
    public int getMaxWorkerThreads() {
        return this.maxWorkerThreads;
    }

    @LegacyConfig(value={"task.shard.max-threads"})
    @Config(value="task.max-worker-threads")
    public TaskManagerConfig setMaxWorkerThreads(int maxWorkerThreads) {
        this.maxWorkerThreads = maxWorkerThreads;
        return this;
    }

    @Min(value=1L)
    public int getInitialSplitsPerNode() {
        if (this.initialSplitsPerNode == null) {
            return this.maxWorkerThreads;
        }
        return this.initialSplitsPerNode;
    }

    @Config(value="task.initial-splits-per-node")
    public TaskManagerConfig setInitialSplitsPerNode(int initialSplitsPerNode) {
        this.initialSplitsPerNode = initialSplitsPerNode;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getSplitConcurrencyAdjustmentInterval() {
        return this.splitConcurrencyAdjustmentInterval;
    }

    @Config(value="task.split-concurrency-adjustment-interval")
    public TaskManagerConfig setSplitConcurrencyAdjustmentInterval(Duration splitConcurrencyAdjustmentInterval) {
        this.splitConcurrencyAdjustmentInterval = splitConcurrencyAdjustmentInterval;
        return this;
    }

    @Min(value=1L)
    public int getMinDrivers() {
        if (this.minDrivers == null) {
            return 2 * this.maxWorkerThreads;
        }
        return this.minDrivers;
    }

    @Config(value="task.min-drivers")
    public TaskManagerConfig setMinDrivers(int minDrivers) {
        this.minDrivers = minDrivers;
        return this;
    }

    @NotNull
    public DataSize getSinkMaxBufferSize() {
        return this.sinkMaxBufferSize;
    }

    @Config(value="sink.max-buffer-size")
    public TaskManagerConfig setSinkMaxBufferSize(DataSize sinkMaxBufferSize) {
        this.sinkMaxBufferSize = sinkMaxBufferSize;
        return this;
    }

    @NotNull
    public DataSize getMaxPagePartitioningBufferSize() {
        return this.maxPagePartitioningBufferSize;
    }

    @Config(value="driver.max-page-partitioning-buffer-size")
    public TaskManagerConfig setMaxPagePartitioningBufferSize(DataSize size) {
        this.maxPagePartitioningBufferSize = size;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="task.client.timeout")
    public TaskManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @NotNull
    public Duration getInfoMaxAge() {
        return this.infoMaxAge;
    }

    @Config(value="task.info.max-age")
    public TaskManagerConfig setInfoMaxAge(Duration infoMaxAge) {
        this.infoMaxAge = infoMaxAge;
        return this;
    }

    @Min(value=1L)
    public int getWriterCount() {
        return this.writerCount;
    }

    @Config(value="task.writer-count")
    @ConfigDescription(value="Number of writers per task")
    public TaskManagerConfig setWriterCount(int writerCount) {
        this.writerCount = writerCount;
        return this;
    }

    @Min(value=1L)
    public int getTaskJoinConcurrency() {
        if (this.taskJoinConcurrency == null) {
            return this.taskDefaultConcurrency;
        }
        return this.taskJoinConcurrency;
    }

    @Config(value="task.join-concurrency")
    @ConfigDescription(value="Local concurrency for join operators")
    public TaskManagerConfig setTaskJoinConcurrency(int taskJoinConcurrency) {
        this.taskJoinConcurrency = taskJoinConcurrency;
        return this;
    }

    @Min(value=1L)
    public int getTaskDefaultConcurrency() {
        return this.taskDefaultConcurrency;
    }

    @Config(value="task.default-concurrency")
    @ConfigDescription(value="Default local concurrency for parallel operators")
    public TaskManagerConfig setTaskDefaultConcurrency(int taskDefaultConcurrency) {
        this.taskDefaultConcurrency = taskDefaultConcurrency;
        return this;
    }

    @Min(value=1L)
    public int getHttpResponseThreads() {
        return this.httpResponseThreads;
    }

    @Config(value="task.http-response-threads")
    public TaskManagerConfig setHttpResponseThreads(int httpResponseThreads) {
        this.httpResponseThreads = httpResponseThreads;
        return this;
    }

    @Min(value=1L)
    public int getHttpTimeoutThreads() {
        return this.httpTimeoutThreads;
    }

    @Config(value="task.http-timeout-threads")
    public TaskManagerConfig setHttpTimeoutThreads(int httpTimeoutThreads) {
        this.httpTimeoutThreads = httpTimeoutThreads;
        return this;
    }

    @Min(value=1L)
    public int getTaskNotificationThreads() {
        return this.taskNotificationThreads;
    }

    @Config(value="task.task-notification-threads")
    @ConfigDescription(value="Number of threads used for internal task event notifications")
    public TaskManagerConfig setTaskNotificationThreads(int taskNotificationThreads) {
        this.taskNotificationThreads = taskNotificationThreads;
        return this;
    }
}

