/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.spi.Node;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;

public class FixedCountScheduler
implements StageScheduler {
    private final BiFunction<Node, Integer, RemoteTask> taskScheduler;
    private final Map<Integer, Node> partitionToNode;

    public FixedCountScheduler(SqlStageExecution stage, Map<Integer, Node> partitionToNode) {
        Objects.requireNonNull(stage, "stage is null");
        this.taskScheduler = stage::scheduleTask;
        this.partitionToNode = Objects.requireNonNull(partitionToNode, "partitionToNode is null");
    }

    @VisibleForTesting
    public FixedCountScheduler(BiFunction<Node, Integer, RemoteTask> taskScheduler, Map<Integer, Node> partitionToNode) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "taskScheduler is null");
        this.partitionToNode = Objects.requireNonNull(partitionToNode, "partitionToNode is null");
    }

    @Override
    public ScheduleResult schedule() {
        List newTasks = (List)this.partitionToNode.entrySet().stream().map(entry -> this.taskScheduler.apply((Node)entry.getValue(), (Integer)entry.getKey())).collect(ImmutableCollectors.toImmutableList());
        return new ScheduleResult(true, newTasks, CompletableFuture.completedFuture(null));
    }
}

