/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.spi.Node;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class NodeAssignmentStats {
    private final NodeTaskMap nodeTaskMap;
    private final Map<Node, Integer> assignmentCount = new HashMap<Node, Integer>();
    private final Map<Node, Integer> splitCountByNode = new HashMap<Node, Integer>();
    private final Map<String, Integer> queuedSplitCountByNode = new HashMap<String, Integer>();

    public NodeAssignmentStats(NodeTaskMap nodeTaskMap, NodeMap nodeMap, List<RemoteTask> existingTasks) {
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        for (Node node : nodeMap.getNodesByHostAndPort().values()) {
            this.assignmentCount.put(node, 0);
        }
        for (RemoteTask task : existingTasks) {
            String nodeId = task.getNodeId();
            this.queuedSplitCountByNode.put(nodeId, this.queuedSplitCountByNode.getOrDefault(nodeId, 0) + task.getQueuedPartitionedSplitCount());
        }
    }

    public int getTotalSplitCount(Node node) {
        return this.assignmentCount.getOrDefault(node, 0) + this.splitCountByNode.computeIfAbsent(node, this.nodeTaskMap::getPartitionedSplitsOnNode);
    }

    public int getTotalQueuedSplitCount(Node node) {
        return this.queuedSplitCountByNode.getOrDefault(node.getNodeIdentifier(), 0) + this.assignmentCount.getOrDefault(node, 0);
    }

    public void addAssignedSplit(Node node) {
        this.assignmentCount.merge(node, 1, (x, y) -> x + y);
    }
}

