/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NetworkLocationCache;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeAssignmentStats;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.NodeSelector;
import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.facebook.presto.execution.scheduler.SimpleNodeSelector;
import com.facebook.presto.execution.scheduler.TopologyAwareNodeSelector;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.sql.planner.NodePartitionMap;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import io.airlift.stats.CounterStat;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class NodeScheduler {
    private final NetworkLocationCache networkLocationCache;
    private final List<CounterStat> topologicalSplitCounters;
    private final List<String> networkLocationSegmentNames;
    private final NodeManager nodeManager;
    private final int minCandidates;
    private final boolean includeCoordinator;
    private final int maxSplitsPerNode;
    private final int maxSplitsPerNodePerTaskWhenFull;
    private final NodeTaskMap nodeTaskMap;
    private final boolean doubleScheduling;
    private final boolean useNetworkTopology;

    @Inject
    public NodeScheduler(NetworkTopology networkTopology, NodeManager nodeManager, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap) {
        this(new NetworkLocationCache(networkTopology), networkTopology, nodeManager, config, nodeTaskMap);
    }

    public NodeScheduler(NetworkLocationCache networkLocationCache, NetworkTopology networkTopology, NodeManager nodeManager, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap) {
        this.networkLocationCache = networkLocationCache;
        this.nodeManager = nodeManager;
        this.minCandidates = config.getMinCandidates();
        this.includeCoordinator = config.isIncludeCoordinator();
        this.doubleScheduling = config.isMultipleTasksPerNodeEnabled();
        this.maxSplitsPerNode = config.getMaxSplitsPerNode();
        this.maxSplitsPerNodePerTaskWhenFull = config.getMaxPendingSplitsPerNodePerTask();
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        Preconditions.checkArgument((this.maxSplitsPerNode > this.maxSplitsPerNodePerTaskWhenFull ? 1 : 0) != 0, (Object)"maxSplitsPerNode must be > maxSplitsPerNodePerTaskWhenFull");
        this.useNetworkTopology = !config.getNetworkTopology().equals("legacy");
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.useNetworkTopology) {
            this.networkLocationSegmentNames = ImmutableList.copyOf(networkTopology.getLocationSegmentNames());
            for (int i = 0; i < this.networkLocationSegmentNames.size() + 1; ++i) {
                builder.add((Object)new CounterStat());
            }
        } else {
            this.networkLocationSegmentNames = ImmutableList.of();
        }
        this.topologicalSplitCounters = builder.build();
    }

    @PreDestroy
    public void stop() {
        this.networkLocationCache.stop();
    }

    public Map<String, CounterStat> getTopologicalSplitCounters() {
        ImmutableMap.Builder counters = ImmutableMap.builder();
        for (int i = 0; i < this.topologicalSplitCounters.size(); ++i) {
            counters.put((Object)(i == 0 ? "all" : this.networkLocationSegmentNames.get(i - 1)), (Object)this.topologicalSplitCounters.get(i));
        }
        return counters.build();
    }

    public NodeSelector createNodeSelector(String dataSourceName) {
        Supplier nodeMap = Suppliers.memoizeWithExpiration(() -> {
            ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
            ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
            ImmutableSetMultimap.Builder workersByNetworkPath = ImmutableSetMultimap.builder();
            Set nodes = dataSourceName != null ? this.nodeManager.getActiveDatasourceNodes(dataSourceName) : this.nodeManager.getNodes(NodeState.ACTIVE);
            Set coordinatorNodeIds = (Set)this.nodeManager.getCoordinators().stream().map(Node::getNodeIdentifier).collect(ImmutableCollectors.toImmutableSet());
            for (Node node : nodes) {
                if (this.useNetworkTopology && (this.includeCoordinator || !coordinatorNodeIds.contains(node.getNodeIdentifier()))) {
                    NetworkLocation location = this.networkLocationCache.get(node.getHostAndPort());
                    for (int i = 0; i <= location.getSegments().size(); ++i) {
                        workersByNetworkPath.put((Object)location.subLocation(0, i), (Object)node);
                    }
                }
                try {
                    byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                    InetAddress host = InetAddress.getByName(node.getHttpUri().getHost());
                    byHost.put((Object)host, (Object)node);
                }
                catch (UnknownHostException unknownHostException) {}
            }
            return new NodeMap((SetMultimap<HostAddress, Node>)byHostAndPort.build(), (SetMultimap<InetAddress, Node>)byHost.build(), (SetMultimap<NetworkLocation, Node>)workersByNetworkPath.build(), coordinatorNodeIds);
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        if (this.useNetworkTopology) {
            return new TopologyAwareNodeSelector(this.nodeManager, this.nodeTaskMap, this.includeCoordinator, this.doubleScheduling, (Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsPerNode, this.maxSplitsPerNodePerTaskWhenFull, this.topologicalSplitCounters, this.networkLocationSegmentNames, this.networkLocationCache);
        }
        return new SimpleNodeSelector(this.nodeManager, this.nodeTaskMap, this.includeCoordinator, this.doubleScheduling, (Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsPerNode, this.maxSplitsPerNodePerTaskWhenFull);
    }

    public static List<Node> selectNodes(int limit, Iterator<Node> candidates, boolean doubleScheduling) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be at least 1");
        ArrayList<Node> selected = new ArrayList<Node>(limit);
        while (selected.size() < limit && candidates.hasNext()) {
            selected.add(candidates.next());
        }
        if (doubleScheduling && !selected.isEmpty()) {
            int uniqueNodes = selected.size();
            int i = 0;
            while (selected.size() < limit) {
                if (i >= uniqueNodes) {
                    i = 0;
                }
                selected.add((Node)selected.get(i));
                ++i;
            }
        }
        return selected;
    }

    public static ResettableRandomizedIterator<Node> randomizedNodes(NodeMap nodeMap, boolean includeCoordinator) {
        ImmutableList nodes = nodeMap.getNodesByHostAndPort().values().stream().filter(node -> includeCoordinator || !nodeMap.getCoordinatorNodeIds().contains(node.getNodeIdentifier())).collect(ImmutableCollectors.toImmutableList());
        return new ResettableRandomizedIterator<Node>((Collection<Node>)nodes);
    }

    public static List<Node> selectExactNodes(NodeMap nodeMap, List<HostAddress> hosts, boolean includeCoordinator) {
        InetAddress address;
        LinkedHashSet chosen = new LinkedHashSet();
        Set<String> coordinatorIds = nodeMap.getCoordinatorNodeIds();
        for (HostAddress host : hosts) {
            nodeMap.getNodesByHostAndPort().get((Object)host).stream().filter(node -> includeCoordinator || !coordinatorIds.contains(node.getNodeIdentifier())).forEach(chosen::add);
            try {
                address = host.toInetAddress();
            }
            catch (UnknownHostException e) {
                continue;
            }
            if (host.hasPort()) continue;
            nodeMap.getNodesByHost().get((Object)address).stream().filter(node -> includeCoordinator || !coordinatorIds.contains(node.getNodeIdentifier())).forEach(chosen::add);
        }
        if (chosen.isEmpty() && !includeCoordinator) {
            for (HostAddress host : hosts) {
                nodeMap.getNodesByHostAndPort().get((Object)host).stream().forEach(chosen::add);
                try {
                    address = host.toInetAddress();
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (host.hasPort()) continue;
                nodeMap.getNodesByHost().get((Object)address).stream().forEach(chosen::add);
            }
        }
        return ImmutableList.copyOf(chosen);
    }

    public static Multimap<Node, Split> selectDistributionNodes(NodeMap nodeMap, NodeTaskMap nodeTaskMap, int maxSplitsPerNode, Set<Split> splits, List<RemoteTask> existingTasks, NodePartitionMap partitioning) {
        HashMultimap assignments = HashMultimap.create();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(nodeTaskMap, nodeMap, existingTasks);
        for (Split split : splits) {
            Node node = partitioning.getNode(split);
            if (assignmentStats.getTotalSplitCount(node) >= maxSplitsPerNode) continue;
            assignments.put((Object)node, (Object)split);
        }
        return ImmutableMultimap.copyOf((Multimap)assignments);
    }
}

