/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.TaskId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

interface OutputBufferManager {
    public void addOutputBuffers(List<OutputBuffer> var1, boolean var2);

    public static class OutputBuffer {
        private final TaskId bufferId;
        private final int partition;

        public OutputBuffer(TaskId bufferId, int partition) {
            this.bufferId = Objects.requireNonNull(bufferId, "bufferId is null");
            Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)"partition is negative");
            this.partition = partition;
        }

        public TaskId getBufferId() {
            return this.bufferId;
        }

        public int getPartition() {
            return this.partition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutputBuffer that = (OutputBuffer)o;
            return this.partition == that.partition && Objects.equals(this.bufferId, that.bufferId);
        }

        public int hashCode() {
            return Objects.hash(this.bufferId, this.partition);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("bufferId", (Object)this.bufferId).add("partition", this.partition).toString();
        }
    }
}

