/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.NodeAssignmentStats;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSelector;
import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.NodePartitionMap;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import io.airlift.log.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class SimpleNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(SimpleNodeSelector.class);
    private final NodeManager nodeManager;
    private final NodeTaskMap nodeTaskMap;
    private final boolean includeCoordinator;
    private final boolean doubleScheduling;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final int minCandidates;
    private final int maxSplitsPerNode;
    private final int maxSplitsPerNodePerTaskWhenFull;

    public SimpleNodeSelector(NodeManager nodeManager, NodeTaskMap nodeTaskMap, boolean includeCoordinator, boolean doubleScheduling, Supplier<NodeMap> nodeMap, int minCandidates, int maxSplitsPerNode, int maxSplitsPerNodePerTaskWhenFull) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.includeCoordinator = includeCoordinator;
        this.doubleScheduling = doubleScheduling;
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        this.minCandidates = minCandidates;
        this.maxSplitsPerNode = maxSplitsPerNode;
        this.maxSplitsPerNodePerTaskWhenFull = maxSplitsPerNodePerTaskWhenFull;
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)this.nodeMap.get().get()));
    }

    @Override
    public List<Node> allNodes() {
        return ImmutableList.copyOf((Collection)((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values());
    }

    @Override
    public Node selectCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    @Override
    public List<Node> selectRandomNodes(int limit) {
        return NodeScheduler.selectNodes(limit, NodeScheduler.randomizedNodes((NodeMap)this.nodeMap.get().get(), this.includeCoordinator), this.doubleScheduling);
    }

    @Override
    public Multimap<Node, Split> computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        HashMultimap assignment = HashMultimap.create();
        NodeMap nodeMap = (NodeMap)this.nodeMap.get().get();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        ResettableRandomizedIterator<Node> randomCandidates = NodeScheduler.randomizedNodes(nodeMap, this.includeCoordinator);
        for (Split split : splits) {
            int totalSplitCount;
            randomCandidates.reset();
            List<Node> candidateNodes = !split.isRemotelyAccessible() ? NodeScheduler.selectExactNodes(nodeMap, split.getAddresses(), this.includeCoordinator) : NodeScheduler.selectNodes(this.minCandidates, randomCandidates, this.doubleScheduling);
            if (candidateNodes.isEmpty()) {
                log.debug("No nodes available to schedule %s. Available nodes %s", new Object[]{split, nodeMap.getNodesByHost().keys()});
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
            }
            Node chosenNode = null;
            int min = Integer.MAX_VALUE;
            for (Node node : candidateNodes) {
                totalSplitCount = assignmentStats.getTotalSplitCount(node);
                if (totalSplitCount >= min || totalSplitCount >= this.maxSplitsPerNode) continue;
                chosenNode = node;
                min = totalSplitCount;
            }
            if (chosenNode == null) {
                for (Node node : candidateNodes) {
                    totalSplitCount = assignmentStats.getTotalQueuedSplitCount(node);
                    if (totalSplitCount >= min || totalSplitCount >= this.maxSplitsPerNodePerTaskWhenFull) continue;
                    chosenNode = node;
                    min = totalSplitCount;
                }
            }
            if (chosenNode == null) continue;
            assignment.put(chosenNode, (Object)split);
            assignmentStats.addAssignedSplit(chosenNode);
        }
        return assignment;
    }

    @Override
    public Multimap<Node, Split> computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, NodePartitionMap partitioning) {
        return NodeScheduler.selectDistributionNodes((NodeMap)this.nodeMap.get().get(), this.nodeTaskMap, this.maxSplitsPerNode, splits, existingTasks, partitioning);
    }
}

