/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.execution.QueryId;
import com.facebook.presto.memory.MemoryPoolId;
import com.facebook.presto.memory.MemoryPoolInfo;
import com.facebook.presto.operator.Operator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.Managed;

public class MemoryPool {
    private final MemoryPoolId id;
    private final long maxBytes;
    @GuardedBy(value="this")
    private long freeBytes;
    @Nullable
    @GuardedBy(value="this")
    private SettableFuture<?> future;
    @GuardedBy(value="this")
    private final Map<QueryId, Long> queryMemoryReservations = new HashMap<QueryId, Long>();

    public MemoryPool(MemoryPoolId id, DataSize size) {
        this.id = Objects.requireNonNull(id, "name is null");
        Objects.requireNonNull(size, "size is null");
        this.maxBytes = size.toBytes();
        this.freeBytes = size.toBytes();
    }

    public MemoryPoolId getId() {
        return this.id;
    }

    public synchronized MemoryPoolInfo getInfo() {
        return new MemoryPoolInfo(this.maxBytes, this.freeBytes, this.queryMemoryReservations);
    }

    public synchronized ListenableFuture<?> reserve(QueryId queryId, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (bytes != 0L) {
            this.queryMemoryReservations.merge(queryId, bytes, Long::sum);
        }
        this.freeBytes -= bytes;
        if (this.freeBytes <= 0L) {
            if (this.future == null) {
                this.future = SettableFuture.create();
            }
            Preconditions.checkState((!this.future.isDone() ? 1 : 0) != 0, (Object)"future is already completed");
            return this.future;
        }
        return Operator.NOT_BLOCKED;
    }

    public synchronized boolean tryReserve(QueryId queryId, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.freeBytes - bytes < 0L) {
            return false;
        }
        this.freeBytes -= bytes;
        if (bytes != 0L) {
            this.queryMemoryReservations.merge(queryId, bytes, Long::sum);
        }
        return true;
    }

    public synchronized void free(QueryId queryId, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.freeBytes + bytes <= this.maxBytes ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        if (bytes == 0L) {
            return;
        }
        Long queryReservation = this.queryMemoryReservations.get(queryId);
        Objects.requireNonNull(queryReservation, "queryReservation is null");
        Preconditions.checkArgument((queryReservation - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved by query");
        queryReservation = queryReservation - bytes;
        if (queryReservation == 0L) {
            this.queryMemoryReservations.remove(queryId);
        } else {
            this.queryMemoryReservations.put(queryId, queryReservation);
        }
        this.freeBytes += bytes;
        if (this.freeBytes > 0L && this.future != null) {
            this.future.set(null);
            this.future = null;
        }
    }

    @Managed
    public synchronized long getFreeBytes() {
        return this.freeBytes;
    }

    @Managed
    public synchronized long getMaxBytes() {
        return this.maxBytes;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("maxBytes", this.maxBytes).add("freeBytes", this.freeBytes).add("future", this.future).toString();
    }
}

