/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.spi.type.Type;
import java.util.Map;
import java.util.Objects;

public class SpecializedFunctionKey {
    private final SqlFunction function;
    private final Map<String, Type> boundTypeParameters;
    private final int arity;

    public SpecializedFunctionKey(SqlFunction function, Map<String, Type> boundTypeParameters, int arity) {
        this.function = Objects.requireNonNull(function, "function is null");
        this.boundTypeParameters = Objects.requireNonNull(boundTypeParameters, "boundTypeParameters is null");
        this.arity = arity;
    }

    public SqlFunction getFunction() {
        return this.function;
    }

    public Map<String, Type> getBoundTypeParameters() {
        return this.boundTypeParameters;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecializedFunctionKey that = (SpecializedFunctionKey)o;
        return Objects.equals(this.arity, that.arity) && Objects.equals(this.boundTypeParameters, that.boundTypeParameters) && Objects.equals(this.function.getSignature(), that.function.getSignature());
    }

    public int hashCode() {
        return Objects.hash(this.function.getSignature(), this.boundTypeParameters, this.arity);
    }
}

