/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class SqlAggregationFunction
implements SqlFunction {
    private final Signature signature;

    public static SqlAggregationFunction create(String name, String description, InternalAggregationFunction function) {
        return new SimpleSqlAggregationFunction(name, description, function);
    }

    protected SqlAggregationFunction(String name, List<TypeParameterRequirement> typeParameterRequirements, String returnType, List<String> argumentTypes) {
        this(name, typeParameterRequirements, returnType, argumentTypes, FunctionKind.AGGREGATE, (Set<String>)ImmutableSet.of());
    }

    protected SqlAggregationFunction(String name, List<TypeParameterRequirement> typeParameterRequirements, String returnType, List<String> argumentTypes, FunctionKind kind, Set<String> literalParameters) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeParameterRequirements, "typeParameters is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        Objects.requireNonNull(literalParameters, "argumentTypes is null");
        Preconditions.checkArgument((kind == FunctionKind.AGGREGATE || kind == FunctionKind.APPROXIMATE_AGGREGATE ? 1 : 0) != 0, (Object)"kind must be an aggregate");
        this.signature = new Signature(name, kind, (List<TypeParameterRequirement>)ImmutableList.copyOf(typeParameterRequirements), returnType, (List<String>)ImmutableList.copyOf(argumentTypes), false, literalParameters);
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    public abstract InternalAggregationFunction specialize(Map<String, Type> var1, int var2, TypeManager var3, FunctionRegistry var4);

    public static class SimpleSqlAggregationFunction
    extends SqlAggregationFunction {
        private final InternalAggregationFunction function;
        private final String description;

        public SimpleSqlAggregationFunction(String name, String description, InternalAggregationFunction function) {
            super(name, (List<TypeParameterRequirement>)ImmutableList.of(), function.getFinalType().getTypeSignature().toString(), (List)function.getParameterTypes().stream().map(Type::getTypeSignature).map(TypeSignature::toString).collect(ImmutableCollectors.toImmutableList()), function.isApproximate() ? FunctionKind.APPROXIMATE_AGGREGATE : FunctionKind.AGGREGATE, (Set<String>)ImmutableSet.of());
            this.description = description;
            this.function = Objects.requireNonNull(function, "function is null");
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public InternalAggregationFunction specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return this.function;
        }
    }
}

