/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TablePropertyManager {
    private final ConcurrentMap<String, Map<String, PropertyMetadata<?>>> catalogTableProperties = new ConcurrentHashMap();

    public void addTableProperties(String catalog, List<PropertyMetadata<?>> tableProperties) {
        Objects.requireNonNull(catalog, "catalog is null");
        Preconditions.checkArgument((!catalog.isEmpty() && catalog.trim().equals(catalog) ? 1 : 0) != 0, (String)"Invalid catalog name '%s'", (Object[])new Object[]{catalog});
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(tableProperties, PropertyMetadata::getName);
        Preconditions.checkState((this.catalogTableProperties.putIfAbsent(catalog, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"TableProperties for catalog '%s' are already registered", (Object[])new Object[]{catalog});
    }

    public Map<String, Object> getTableProperties(String catalog, Map<String, Expression> sqlPropertyValues, Session session, Metadata metadata) {
        Map supportedTableProperties = (Map)this.catalogTableProperties.get(catalog);
        if (supportedTableProperties == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog not found: " + catalog);
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        for (Map.Entry<String, Expression> sqlProperty : sqlPropertyValues.entrySet()) {
            Object value;
            Object sqlObjectValue;
            String property = sqlProperty.getKey().toLowerCase(Locale.ENGLISH);
            PropertyMetadata tableProperty = (PropertyMetadata)supportedTableProperties.get(property);
            if (tableProperty == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Catalog '%s' does not support table property '%s'", catalog, property));
            }
            try {
                sqlObjectValue = TablePropertyManager.evaluatePropertyValue(sqlProperty.getValue(), tableProperty.getSqlType(), session, metadata);
            }
            catch (SemanticException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Invalid value for table property '%s': Cannot convert '%s' to %s", tableProperty.getName(), sqlProperty.getValue(), tableProperty.getSqlType()), (Throwable)e);
            }
            try {
                value = tableProperty.decode(sqlObjectValue);
            }
            catch (Exception e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Unable to set table property '%s' to '%s': %s", tableProperty.getName(), sqlProperty.getValue(), e.getMessage()), (Throwable)e);
            }
            properties.put((Object)tableProperty.getName(), value);
        }
        ImmutableMap userSpecifiedProperties = properties.build();
        for (PropertyMetadata tableProperty : supportedTableProperties.values()) {
            Object value;
            if (userSpecifiedProperties.containsKey(tableProperty.getName()) || (value = tableProperty.getDefaultValue()) == null) continue;
            properties.put((Object)tableProperty.getName(), value);
        }
        return properties.build();
    }

    public Map<String, Map<String, PropertyMetadata<?>>> getAllTableProperties() {
        return ImmutableMap.copyOf(this.catalogTableProperties);
    }

    private static Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, Metadata metadata) {
        Object value = ExpressionInterpreter.evaluateConstantExpression(expression, expectedType, metadata, session);
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(new BlockBuilderStatus(), 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Table property value cannot be null");
        }
        return objectValue;
    }
}

