/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DeleteOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

public class Driver
implements Closeable {
    private static final Logger log = Logger.get(Driver.class);
    private final DriverContext driverContext;
    private final List<Operator> operators;
    private final Map<PlanNodeId, SourceOperator> sourceOperators;
    private final Optional<DeleteOperator> deleteOperator;
    private final ConcurrentMap<PlanNodeId, TaskSource> newSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.ALIVE);
    private final ReentrantLock exclusiveLock = new ReentrantLock();
    @GuardedBy(value="this")
    private Thread lockHolder;
    @GuardedBy(value="exclusiveLock")
    private final Map<PlanNodeId, TaskSource> currentSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();

    public Driver(DriverContext driverContext, Operator firstOperator, Operator ... otherOperators) {
        this(Objects.requireNonNull(driverContext, "driverContext is null"), (List<Operator>)ImmutableList.builder().add((Object)Objects.requireNonNull(firstOperator, "firstOperator is null")).add((Object[])Objects.requireNonNull(otherOperators, "otherOperators is null")).build());
    }

    public Driver(DriverContext driverContext, List<Operator> operators) {
        this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
        this.operators = ImmutableList.copyOf((Collection)Objects.requireNonNull(operators, "operators is null"));
        Preconditions.checkArgument((!operators.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one operator");
        ImmutableMap.Builder sourceOperators = ImmutableMap.builder();
        Optional<Object> deleteOperator = Optional.empty();
        for (Operator operator : operators) {
            if (operator instanceof SourceOperator) {
                SourceOperator sourceOperator = (SourceOperator)operator;
                sourceOperators.put((Object)sourceOperator.getSourceId(), (Object)sourceOperator);
                continue;
            }
            if (!(operator instanceof DeleteOperator)) continue;
            Preconditions.checkArgument((!deleteOperator.isPresent() ? 1 : 0) != 0, (Object)"There must be at most one DeleteOperator");
            deleteOperator = Optional.of((DeleteOperator)operator);
        }
        this.sourceOperators = sourceOperators.build();
        this.deleteOperator = deleteOperator;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Set<PlanNodeId> getSourceIds() {
        return this.sourceOperators.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            if (!this.state.compareAndSet(State.ALIVE, State.NEED_DESTRUCTION)) {
                return;
            }
            try (DriverLockResult lockResult = this.tryLockAndProcessPendingStateChanges(0, TimeUnit.MILLISECONDS);){
                if (lockResult.wasAcquired()) break block17;
                Driver driver = this;
                synchronized (driver) {
                    if (this.lockHolder != null) {
                        this.lockHolder.interrupt();
                    }
                }
            }
        }
    }

    public boolean isFinished() {
        this.checkLockNotHeld("Can not check finished status while holding the driver lock");
        try (DriverLockResult lockResult = this.tryLockAndProcessPendingStateChanges(0, TimeUnit.MILLISECONDS);){
            if (lockResult.wasAcquired()) {
                boolean bl = this.isFinishedInternal();
                return bl;
            }
            boolean bl = this.state.get() != State.ALIVE || this.driverContext.isDone();
            return bl;
        }
    }

    private boolean isFinishedInternal() {
        boolean finished;
        this.checkLockHeld("Lock must be held to call isFinishedInternal");
        boolean bl = finished = this.state.get() != State.ALIVE || this.driverContext.isDone() || this.operators.get(this.operators.size() - 1).isFinished();
        if (finished) {
            this.state.compareAndSet(State.ALIVE, State.NEED_DESTRUCTION);
        }
        return finished;
    }

    public void updateSource(TaskSource source) {
        TaskSource newSource;
        TaskSource currentNewSource;
        this.checkLockNotHeld("Can not update sources while holding the driver lock");
        if (!this.sourceOperators.containsKey(source.getPlanNodeId())) {
            return;
        }
        while ((currentNewSource = this.newSources.putIfAbsent(source.getPlanNodeId(), source)) != null && (newSource = currentNewSource.update(source)) != currentNewSource && !this.newSources.replace(source.getPlanNodeId(), currentNewSource, newSource)) {
        }
        this.tryLockAndProcessPendingStateChanges(0, TimeUnit.MILLISECONDS).close();
    }

    private void processNewSources() {
        this.checkLockHeld("Lock must be held to call processNewSources");
        if (this.state.get() != State.ALIVE) {
            return;
        }
        HashMap<PlanNodeId, TaskSource> sources = new HashMap<PlanNodeId, TaskSource>(this.newSources);
        for (Map.Entry entry : sources.entrySet()) {
            this.newSources.remove(entry.getKey(), entry.getValue());
            this.processNewSource((TaskSource)entry.getValue());
        }
    }

    private void processNewSource(TaskSource source) {
        Sets.SetView newSplits;
        this.checkLockHeld("Lock must be held to call processNewSources");
        TaskSource currentSource = this.currentSources.get(source.getPlanNodeId());
        if (currentSource == null) {
            newSplits = source.getSplits();
            this.currentSources.put(source.getPlanNodeId(), source);
        } else {
            TaskSource newSource = currentSource.update(source);
            if (newSource == currentSource) {
                return;
            }
            newSplits = Sets.difference(newSource.getSplits(), currentSource.getSplits());
            this.currentSources.put(source.getPlanNodeId(), newSource);
        }
        for (ScheduledSplit newSplit : newSplits) {
            Split split = newSplit.getSplit();
            SourceOperator sourceOperator = this.sourceOperators.get(source.getPlanNodeId());
            if (sourceOperator == null) continue;
            Supplier<Optional<UpdatablePageSource>> pageSource = sourceOperator.addSplit(split);
            if (!this.deleteOperator.isPresent()) continue;
            this.deleteOperator.get().setPageSource(pageSource);
        }
        if (source.isNoMoreSplits()) {
            this.sourceOperators.get(source.getPlanNodeId()).noMoreSplits();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> processFor(Duration duration) {
        block20: {
            this.checkLockNotHeld("Can not process for a duration while holding the driver lock");
            Objects.requireNonNull(duration, "duration is null");
            long maxRuntime = duration.roundTo(TimeUnit.NANOSECONDS);
            try (DriverLockResult lockResult = this.tryLockAndProcessPendingStateChanges(100, TimeUnit.MILLISECONDS);){
                if (!lockResult.wasAcquired()) break block20;
                this.driverContext.startProcessTimer();
                try {
                    long start = System.nanoTime();
                    do {
                        ListenableFuture<?> future;
                        if ((future = this.processInternal()).isDone()) continue;
                        ListenableFuture<?> listenableFuture = future;
                        return listenableFuture;
                    } while (System.nanoTime() - start < maxRuntime && !this.isFinishedInternal());
                }
                finally {
                    this.driverContext.recordProcessed();
                }
            }
        }
        return Operator.NOT_BLOCKED;
    }

    public ListenableFuture<?> process() {
        this.checkLockNotHeld("Can not process while holding the driver lock");
        try (DriverLockResult lockResult = this.tryLockAndProcessPendingStateChanges(100, TimeUnit.MILLISECONDS);){
            if (!lockResult.wasAcquired()) {
                ListenableFuture<?> listenableFuture = Operator.NOT_BLOCKED;
                return listenableFuture;
            }
            ListenableFuture<?> listenableFuture = this.processInternal();
            return listenableFuture;
        }
    }

    private ListenableFuture<?> processInternal() {
        this.checkLockHeld("Lock must be held to call processInternal");
        try {
            if (!this.newSources.isEmpty()) {
                this.processNewSources();
            }
            if (this.operators.size() == 1) {
                if (this.driverContext.isDone()) {
                    return Operator.NOT_BLOCKED;
                }
                Operator current = this.operators.get(0);
                ListenableFuture<?> blocked = Driver.isBlocked(current);
                if (!blocked.isDone()) {
                    current.getOperatorContext().recordBlocked(blocked);
                    return blocked;
                }
                current.getOperatorContext().startIntervalTimer();
                current.finish();
                current.getOperatorContext().recordFinish();
                return Operator.NOT_BLOCKED;
            }
            boolean movedPage = false;
            for (int i = 0; i < this.operators.size() - 1 && !this.driverContext.isDone(); ++i) {
                Operator current = this.operators.get(i);
                Operator next = this.operators.get(i + 1);
                if (!Driver.isBlocked(current).isDone() || !Driver.isBlocked(next).isDone()) continue;
                if (!current.isFinished() && next.needsInput()) {
                    current.getOperatorContext().startIntervalTimer();
                    Page page = current.getOutput();
                    current.getOperatorContext().recordGetOutput(page);
                    if (page != null) {
                        next.getOperatorContext().startIntervalTimer();
                        next.addInput(page);
                        next.getOperatorContext().recordAddInput(page);
                        movedPage = true;
                    }
                }
                if (!current.isFinished()) continue;
                next.getOperatorContext().startIntervalTimer();
                next.finish();
                next.getOperatorContext().recordFinish();
            }
            if (!movedPage) {
                ArrayList<Operator> blockedOperators = new ArrayList<Operator>();
                ArrayList blockedFutures = new ArrayList();
                for (Operator operator : this.operators) {
                    ListenableFuture<?> blocked = Driver.isBlocked(operator);
                    if (blocked.isDone()) continue;
                    blockedOperators.add(operator);
                    blockedFutures.add(blocked);
                }
                if (!blockedFutures.isEmpty()) {
                    ListenableFuture<?> blocked = Driver.firstFinishedFuture(blockedFutures);
                    this.driverContext.recordBlocked(blocked);
                    for (Operator operator : blockedOperators) {
                        operator.getOperatorContext().recordBlocked(blocked);
                    }
                    return blocked;
                }
            }
            return Operator.NOT_BLOCKED;
        }
        catch (Throwable t) {
            this.driverContext.failed(t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfNecessary() {
        this.checkLockHeld("Lock must be held to call destroyIfNecessary");
        if (!this.state.compareAndSet(State.NEED_DESTRUCTION, State.DESTROYED)) {
            return;
        }
        boolean wasInterrupted = Thread.interrupted();
        Throwable inFlightException = null;
        try {
            for (Operator operator : this.operators) {
                try {
                    operator.close();
                }
                catch (InterruptedException t) {
                    wasInterrupted = true;
                }
                catch (Throwable t) {
                    inFlightException = Driver.addSuppressedException(inFlightException, t, "Error closing operator %s for task %s", operator.getOperatorContext().getOperatorId(), this.driverContext.getTaskId());
                }
                try {
                    operator.getOperatorContext().setMemoryReservation(0L);
                }
                catch (Throwable t) {
                    inFlightException = Driver.addSuppressedException(inFlightException, t, "Error freeing memory for operator %s for task %s", operator.getOperatorContext().getOperatorId(), this.driverContext.getTaskId());
                }
                try {
                    operator.getOperatorContext().closeSystemMemoryContext();
                }
                catch (Throwable t) {
                    inFlightException = Driver.addSuppressedException(inFlightException, t, "Error freeing system memory for operator %s for task %s", operator.getOperatorContext().getOperatorId(), this.driverContext.getTaskId());
                }
            }
            this.driverContext.finished();
        }
        catch (Throwable t) {
            inFlightException = Driver.addSuppressedException(inFlightException, t, "Error destroying driver for task %s", this.driverContext.getTaskId());
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (inFlightException != null) {
            throw Throwables.propagate(inFlightException);
        }
    }

    private static ListenableFuture<?> isBlocked(Operator operator) {
        ListenableFuture<?> blocked = operator.isBlocked();
        if (blocked.isDone()) {
            blocked = operator.getOperatorContext().isWaitingForMemory();
        }
        return blocked;
    }

    private static Throwable addSuppressedException(Throwable inFlightException, Throwable newException, String message, Object ... args) {
        if (newException instanceof Error) {
            if (inFlightException == null) {
                inFlightException = newException;
            } else if (inFlightException != newException) {
                inFlightException.addSuppressed(newException);
            }
        } else {
            log.error(newException, message, args);
        }
        return inFlightException;
    }

    private DriverLockResult tryLockAndProcessPendingStateChanges(int timeout, TimeUnit unit) {
        this.checkLockNotHeld("Can not acquire the driver lock while already holding the driver lock");
        return new DriverLockResult(timeout, unit);
    }

    private synchronized void checkLockNotHeld(String message) {
        Preconditions.checkState((Thread.currentThread() != this.lockHolder ? 1 : 0) != 0, (Object)message);
    }

    private synchronized void checkLockHeld(String message) {
        Preconditions.checkState((Thread.currentThread() == this.lockHolder ? 1 : 0) != 0, (Object)message);
    }

    private static ListenableFuture<?> firstFinishedFuture(List<ListenableFuture<?>> futures) {
        SettableFuture result = SettableFuture.create();
        ListeningExecutorService executor = MoreExecutors.newDirectExecutorService();
        for (ListenableFuture<?> future : futures) {
            future.addListener(() -> result.set(null), (Executor)executor);
        }
        return result;
    }

    private class DriverLockResult
    implements AutoCloseable {
        private final boolean acquired;

        private DriverLockResult(int timeout, TimeUnit unit) {
            this.acquired = this.tryAcquire(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryAcquire(int timeout, TimeUnit unit) {
            boolean acquired = false;
            try {
                acquired = Driver.this.exclusiveLock.tryLock(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (acquired) {
                Driver driver = Driver.this;
                synchronized (driver) {
                    Driver.this.lockHolder = Thread.currentThread();
                }
            }
            return acquired;
        }

        public boolean wasAcquired() {
            return this.acquired;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.acquired) {
                return;
            }
            boolean done = false;
            while (!done) {
                done = true;
                try {
                    try {
                        Driver.this.processNewSources();
                    }
                    finally {
                        Driver.this.destroyIfNecessary();
                    }
                }
                finally {
                    Driver driver = Driver.this;
                    synchronized (driver) {
                        Driver.this.lockHolder = null;
                    }
                    Driver.this.exclusiveLock.unlock();
                    if (Driver.this.newSources.isEmpty() || Driver.this.state.get() != State.ALIVE || !this.tryAcquire(0, TimeUnit.MILLISECONDS)) continue;
                    done = false;
                }
            }
        }
    }

    private static enum State {
        ALIVE,
        NEED_DESTRUCTION,
        DESTROYED;

    }
}

