/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryPerformanceFetcher;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.PlanPrinter;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ExplainAnalyzeOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final QueryPerformanceFetcher queryPerformanceFetcher;
    private final Metadata metadata;
    private boolean finishing;
    private boolean outputConsumed;

    public ExplainAnalyzeOperator(OperatorContext operatorContext, QueryPerformanceFetcher queryPerformanceFetcher, Metadata metadata) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.queryPerformanceFetcher = Objects.requireNonNull(queryPerformanceFetcher, "queryPerformanceFetcher is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of((Object)VarcharType.VARCHAR);
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputConsumed;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            return null;
        }
        this.outputConsumed = true;
        QueryInfo queryInfo = this.queryPerformanceFetcher.getQueryInfo(this.operatorContext.getDriverContext().getTaskId().getQueryId());
        String plan = PlanPrinter.textDistributedPlan(queryInfo.getOutputStage().getSubStages(), this.metadata, this.operatorContext.getSession());
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus(), 1);
        VarcharType.VARCHAR.writeString(builder, plan);
        return new Page(new Block[]{builder.build()});
    }

    public static class ExplainAnalyzeOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final QueryPerformanceFetcher queryPerformanceFetcher;
        private final Metadata metadata;
        private boolean closed;

        public ExplainAnalyzeOperatorFactory(int operatorId, PlanNodeId planNodeId, QueryPerformanceFetcher queryPerformanceFetcher, Metadata metadata) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.queryPerformanceFetcher = Objects.requireNonNull(queryPerformanceFetcher, "queryPerformanceFetcher is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of((Object)VarcharType.VARCHAR);
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, ExplainAnalyzeOperator.class.getSimpleName());
            return new ExplainAnalyzeOperator(operatorContext, this.queryPerformanceFetcher, this.metadata);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new ExplainAnalyzeOperatorFactory(this.operatorId, this.planNodeId, this.queryPerformanceFetcher, this.metadata);
        }
    }
}

