/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class GenericCursorProcessor
implements CursorProcessor {
    private final FilterFunction filterFunction;
    private final List<ProjectionFunction> projections;

    public GenericCursorProcessor(FilterFunction filterFunction, Iterable<? extends ProjectionFunction> projections) {
        this.filterFunction = filterFunction;
        this.projections = ImmutableList.copyOf(projections);
    }

    @Override
    public int process(ConnectorSession session, RecordCursor cursor, int count, PageBuilder pageBuilder) {
        int position;
        Preconditions.checkArgument((!pageBuilder.isFull() ? 1 : 0) != 0, (Object)"page builder can't be full");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must be > 0");
        for (position = 0; position < count && !pageBuilder.isFull() && cursor.advanceNextPosition(); ++position) {
            if (!this.filterFunction.filter(cursor)) continue;
            pageBuilder.declarePosition();
            for (int channel = 0; channel < this.projections.size(); ++channel) {
                this.projections.get(channel).project(cursor, pageBuilder.getBlockBuilder(channel));
            }
        }
        return position;
    }
}

