/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public class MetadataDeleteOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private final OperatorContext operatorContext;
    private final TableLayoutHandle tableLayout;
    private final Metadata metadata;
    private final Session session;
    private final TableHandle tableHandle;
    private boolean finished;

    public MetadataDeleteOperator(OperatorContext operatorContext, TableLayoutHandle tableLayout, Metadata metadata, Session session, TableHandle tableHandle) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.tableLayout = Objects.requireNonNull(tableLayout, "tableLayout is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return TYPES;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        this.finished = true;
        OptionalLong rowsDeletedCount = this.metadata.metadataDelete(this.session, this.tableHandle, this.tableLayout);
        PageBuilder page = new PageBuilder(TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        page.declarePosition();
        if (rowsDeletedCount.isPresent()) {
            BigintType.BIGINT.writeLong(rowsBuilder, rowsDeletedCount.getAsLong());
        } else {
            rowsBuilder.appendNull();
        }
        return page.build();
    }

    public static class MetadataDeleteOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final TableLayoutHandle tableLayout;
        private final Metadata metadata;
        private final Session session;
        private final TableHandle tableHandle;
        private boolean closed;

        public MetadataDeleteOperatorFactory(int operatorId, PlanNodeId planNodeId, TableLayoutHandle tableLayout, Metadata metadata, Session session, TableHandle tableHandle) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.tableLayout = Objects.requireNonNull(tableLayout, "tableLayout is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @Override
        public List<Type> getTypes() {
            return TYPES;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, MetadataDeleteOperator.class.getSimpleName());
            return new MetadataDeleteOperator(context, this.tableLayout, this.metadata, this.session, this.tableHandle);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new MetadataDeleteOperatorFactory(this.operatorId, this.planNodeId, this.tableLayout, this.metadata, this.session, this.tableHandle);
        }
    }
}

