/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PartitionedLookupSource;
import com.facebook.presto.operator.SharedLookupSource;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class ParallelLookupSourceSupplier
implements LookupSourceSupplier {
    private final List<Type> types;
    private final List<Type> hashChannelTypes;
    private final ListenableFuture<LookupSource> lookupSourceFuture;
    private final List<? extends ListenableFuture<SharedLookupSource>> partitions;
    private final AtomicInteger referenceCount = new AtomicInteger(1);

    public ParallelLookupSourceSupplier(List<Type> types, List<Integer> hashChannels, List<? extends ListenableFuture<SharedLookupSource>> partitions) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.hashChannelTypes = (List)hashChannels.stream().map(types::get).collect(ImmutableCollectors.toImmutableList());
        Preconditions.checkArgument((Integer.bitCount(partitions.size()) == 1 ? 1 : 0) != 0, (Object)"partitions must be a power of 2");
        this.lookupSourceFuture = Futures.transform((ListenableFuture)Futures.allAsList(partitions), input -> new PartitionedLookupSource((List<? extends LookupSource>)input, this.hashChannelTypes));
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public ListenableFuture<LookupSource> getLookupSource(OperatorContext operatorContext) {
        return this.lookupSourceFuture;
    }

    @Override
    public void retain() {
        this.referenceCount.incrementAndGet();
    }

    @Override
    public void release() {
        if (this.referenceCount.decrementAndGet() == 0) {
            for (ListenableFuture<SharedLookupSource> listenableFuture : this.partitions) {
                Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<SharedLookupSource>(){

                    public void onSuccess(SharedLookupSource result) {
                        result.freeMemory();
                    }

                    public void onFailure(Throwable t) {
                    }
                });
            }
        }
    }
}

