/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.LongAndDoubleState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="geometric_mean")
public final class GeometricMeanAggregations {
    private GeometricMeanAggregations() {
    }

    @InputFunction
    public static void input(LongAndDoubleState state, @SqlType(value="bigint") long value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + Math.log(value));
    }

    @InputFunction
    public static void input(LongAndDoubleState state, @SqlType(value="double") double value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + Math.log(value));
    }

    @CombineFunction
    public static void combine(LongAndDoubleState state, LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="double")
    public static void output(LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            DoubleType.DOUBLE.writeDouble(out, Math.exp(state.getDouble() / (double)count));
        }
    }
}

