/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.IntermediateInputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="sum")
public final class LongSumAggregation {
    public static final InternalAggregationFunction LONG_SUM = new AggregationCompiler().generateAggregationFunction(LongSumAggregation.class);

    private LongSumAggregation() {
    }

    @InputFunction
    @IntermediateInputFunction
    public static void sum(NullableLongState state, @SqlType(value="bigint") long value) {
        state.setNull(false);
        state.setLong(state.getLong() + value);
    }

    @OutputFunction(value="bigint")
    public static void output(NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, state, out);
    }
}

