/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.NumericHistogram;
import com.facebook.presto.operator.aggregation.NumericHistogramStateFactory;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateMetadata;
import com.facebook.presto.operator.aggregation.state.NumericHistogramStateSerializer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.primitives.Ints;
import java.util.Map;
import javax.validation.constraints.NotNull;

@AggregationFunction(value="numeric_histogram")
public final class NumericHistogramAggregation {
    public static final int ENTRY_BUFFER_SIZE = 100;

    private NumericHistogramAggregation() {
    }

    @InputFunction
    public static void add(State state, @SqlType(value="bigint") long buckets, @SqlType(value="double") double value, @SqlType(value="double") double weight) {
        NumericHistogram histogram = state.get();
        if (histogram == null) {
            Failures.checkCondition(buckets >= 2L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "numeric_histogram bucket count must be greater than one", new Object[0]);
            histogram = new NumericHistogram(Ints.checkedCast((long)buckets), 100);
            state.set(histogram);
        }
        histogram.add(value, weight);
    }

    @InputFunction
    public static void add(State state, @SqlType(value="bigint") long buckets, @SqlType(value="double") double value) {
        NumericHistogramAggregation.add(state, buckets, value, 1.0);
    }

    @CombineFunction
    public static void merge(State state, State other) {
        NumericHistogram input = other.get();
        NumericHistogram previous = state.get();
        if (previous == null) {
            state.set(input);
        } else {
            previous.mergeWith(input);
        }
    }

    @OutputFunction(value="map(double,double)")
    public static void output(State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            Map<Double, Double> value = state.get().getBuckets();
            BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(new BlockBuilderStatus(), value.size() * 2);
            for (Map.Entry<Double, Double> entry : value.entrySet()) {
                DoubleType.DOUBLE.writeDouble(blockBuilder, entry.getKey().doubleValue());
                DoubleType.DOUBLE.writeDouble(blockBuilder, entry.getValue().doubleValue());
            }
            Block block = blockBuilder.build();
            out.writeObject((Object)block);
            out.closeEntry();
        }
    }

    @AccumulatorStateMetadata(stateSerializerClass=NumericHistogramStateSerializer.class, stateFactoryClass=NumericHistogramStateFactory.class)
    public static interface State
    extends AccumulatorState {
        @NotNull
        public NumericHistogram get();

        public void set(NumericHistogram var1);
    }
}

