/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.RegressionState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="")
public class RegressionAggregation {
    private RegressionAggregation() {
    }

    @InputFunction
    public static void input(RegressionState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateRegressionState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(RegressionState state, RegressionState otherState) {
        AggregationUtils.mergeRegressionState(state, otherState);
    }

    @AggregationFunction(value="regr_slope")
    @OutputFunction(value="double")
    public static void regrSlope(RegressionState state, BlockBuilder out) {
        double divisor;
        double dividend = (double)state.getCount() * state.getSumXY() - state.getSumX() * state.getSumY();
        double result = dividend / (divisor = (double)state.getCount() * state.getSumXSquare() - state.getSumX() * state.getSumX());
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_intercept")
    @OutputFunction(value="double")
    public static void regrIntercept(RegressionState state, BlockBuilder out) {
        double divisor;
        double dividend = state.getSumY() * state.getSumXSquare() - state.getSumX() * state.getSumXY();
        double result = dividend / (divisor = (double)state.getCount() * state.getSumXSquare() - state.getSumX() * state.getSumX());
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }
}

