/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.stats.QuantileDigest;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.List;

public class DigestAndPercentileArrayStateSerializer
implements AccumulatorStateSerializer<DigestAndPercentileArrayState> {
    @Override
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    @Override
    public void serialize(DigestAndPercentileArrayState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(state.getDigest().estimatedSerializedSizeInBytes() + state.getPercentiles().size() * 8 + 8);
            state.getDigest().serialize((DataOutput)sliceOutput);
            List<Double> percentiles = state.getPercentiles();
            sliceOutput.appendLong((long)percentiles.size());
            for (Double percentile : percentiles) {
                sliceOutput.appendDouble(percentile.doubleValue());
            }
            VarbinaryType.VARBINARY.writeSlice(out, sliceOutput.slice());
        }
    }

    @Override
    public void deserialize(Block block, int index, DigestAndPercentileArrayState state) {
        if (!block.isNull(index)) {
            BasicSliceInput input = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
            state.setDigest(QuantileDigest.deserialize((DataInput)input));
            state.addMemoryUsage(state.getDigest().estimatedInMemorySizeInBytes());
            long numPercentiles = input.readLong();
            ImmutableList.Builder percentilesListBuilder = ImmutableList.builder();
            int i = 0;
            while ((long)i < numPercentiles) {
                percentilesListBuilder.add((Object)input.readDouble());
                ++i;
            }
            state.setPercentiles((List<Double>)percentilesListBuilder.build());
        }
    }
}

