/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.TypedHistogram;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.HistogramState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.MapType;

public class HistogramStateSerializer
implements AccumulatorStateSerializer<HistogramState> {
    private final Type type;
    private final Type serializedType;

    public HistogramStateSerializer(Type type) {
        this.type = type;
        this.serializedType = new MapType(type, (Type)BigintType.BIGINT);
    }

    @Override
    public Type getSerializedType() {
        return this.serializedType;
    }

    @Override
    public void serialize(HistogramState state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            this.serializedType.writeObject(out, (Object)state.get().serialize());
        }
    }

    @Override
    public void deserialize(Block block, int index, HistogramState state) {
        if (!block.isNull(index)) {
            state.set(new TypedHistogram((Block)this.serializedType.getObject(block, index), this.type, 10));
        }
    }
}

