/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.TypedHeap;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.MinMaxNState;
import com.facebook.presto.util.array.ObjectBigArray;

public class MinMaxNStateFactory
implements AccumulatorStateFactory<MinMaxNState> {
    @Override
    public MinMaxNState createSingleState() {
        return new SingleMinMaxNState();
    }

    @Override
    public Class<? extends MinMaxNState> getSingleStateClass() {
        return SingleMinMaxNState.class;
    }

    @Override
    public MinMaxNState createGroupedState() {
        return new GroupedMinMaxNState();
    }

    @Override
    public Class<? extends MinMaxNState> getGroupedStateClass() {
        return GroupedMinMaxNState.class;
    }

    public static class SingleMinMaxNState
    implements MinMaxNState {
        private TypedHeap typedHeap;

        @Override
        public long getEstimatedSize() {
            if (this.typedHeap == null) {
                return 0L;
            }
            return this.typedHeap.getEstimatedSize();
        }

        @Override
        public TypedHeap getTypedHeap() {
            return this.typedHeap;
        }

        @Override
        public void setTypedHeap(TypedHeap typedHeap) {
            this.typedHeap = typedHeap;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }
    }

    public static class GroupedMinMaxNState
    extends AbstractGroupedAccumulatorState
    implements MinMaxNState {
        private final ObjectBigArray<TypedHeap> heaps = new ObjectBigArray();
        private long size;

        @Override
        public void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        @Override
        public long getEstimatedSize() {
            return this.heaps.sizeOf() + this.size;
        }

        @Override
        public TypedHeap getTypedHeap() {
            return this.heaps.get(this.getGroupId());
        }

        @Override
        public void setTypedHeap(TypedHeap value) {
            TypedHeap previous = this.getTypedHeap();
            if (previous != null) {
                this.size -= previous.getEstimatedSize();
            }
            this.heaps.set(this.getGroupId(), value);
            this.size += value.getEstimatedSize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }
    }
}

