/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableBooleanState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;

public class NullableBooleanStateSerializer
implements AccumulatorStateSerializer<NullableBooleanState> {
    @Override
    public Type getSerializedType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public void serialize(NullableBooleanState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BooleanType.BOOLEAN.writeBoolean(out, state.getBoolean());
        }
    }

    @Override
    public void deserialize(Block block, int index, NullableBooleanState state) {
        state.setNull(block.isNull(index));
        if (!state.isNull()) {
            state.setBoolean(BooleanType.BOOLEAN.getBoolean(block, index));
        }
    }
}

