/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

public class NullableLongStateSerializer
implements AccumulatorStateSerializer<NullableLongState> {
    @Override
    public Type getSerializedType() {
        return BigintType.BIGINT;
    }

    @Override
    public void serialize(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BigintType.BIGINT.writeLong(out, state.getLong());
        }
    }

    @Override
    public void deserialize(Block block, int index, NullableLongState state) {
        state.setNull(block.isNull(index));
        if (!state.isNull()) {
            state.setLong(BigintType.BIGINT.getLong(block, index));
        }
    }
}

