/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.OperatorDependency;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.operator.scalar.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.EQUAL)
public final class ArrayEqualOperator {
    private ArrayEqualOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean equals(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)i);
            Object rightElement = TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)i);
            try {
                if (equalsFunction.invoke(leftElement, rightElement)) continue;
                return false;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return true;
    }
}

