/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.OperatorDependency;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.operator.scalar.TypeParameter;
import com.facebook.presto.operator.scalar.TypeParameterSpecialization;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
public final class ArrayLessThanOrEqualOperator {
    private ArrayLessThanOrEqualOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle lessThanFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)index);
            Object rightElement = TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)index);
            try {
                if (lessThanFunction.invoke(leftElement, rightElement)) {
                    return true;
                }
                if (!lessThanFunction.invoke(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return leftArray.getPositionCount() <= rightArray.getPositionCount();
    }

    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=long.class)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqualLong(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle lessThanFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            long leftElement = type.getLong(leftArray, index);
            long rightElement = type.getLong(rightArray, index);
            try {
                if (lessThanFunction.invokeExact(leftElement, rightElement)) {
                    return true;
                }
                if (!lessThanFunction.invokeExact(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return leftArray.getPositionCount() <= rightArray.getPositionCount();
    }
}

