/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.OperatorDependency;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.operator.scalar.TypeParameter;
import com.facebook.presto.operator.scalar.TypeParameterContainer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

@ScalarOperator(value=OperatorType.EQUAL)
public final class MapEqualOperator {
    private MapEqualOperator() {
    }

    @TypeParameterContainer(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @Nullable
    @SqlType(value="boolean")
    public static Boolean equals(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"K", "K"}) MethodHandle keyEqualsFunction, @OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"K"}) MethodHandle keyHashcodeFunction, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"V", "V"}) MethodHandle valueEqualsFunction, @TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType, @SqlType(value="map(K,V)") Block leftMapBlock, @SqlType(value="map(K,V)") Block rightMapBlock) {
        LinkedHashMap<KeyWrapper, Integer> wrappedLeftMap = new LinkedHashMap<KeyWrapper, Integer>();
        for (int position = 0; position < leftMapBlock.getPositionCount(); position += 2) {
            wrappedLeftMap.put(new KeyWrapper(TypeUtils.readNativeValue((Type)keyType, (Block)leftMapBlock, (int)position), keyEqualsFunction, keyHashcodeFunction), position + 1);
        }
        LinkedHashMap<KeyWrapper, Integer> wrappedRightMap = new LinkedHashMap<KeyWrapper, Integer>();
        for (int position = 0; position < rightMapBlock.getPositionCount(); position += 2) {
            wrappedRightMap.put(new KeyWrapper(TypeUtils.readNativeValue((Type)keyType, (Block)rightMapBlock, (int)position), keyEqualsFunction, keyHashcodeFunction), position + 1);
        }
        if (wrappedLeftMap.size() != wrappedRightMap.size()) {
            return false;
        }
        for (Map.Entry entry : wrappedRightMap.entrySet()) {
            KeyWrapper key = (KeyWrapper)entry.getKey();
            Integer leftValuePosition = (Integer)wrappedLeftMap.get(key);
            if (leftValuePosition == null) {
                return false;
            }
            Object leftValue = TypeUtils.readNativeValue((Type)valueType, (Block)leftMapBlock, (int)leftValuePosition);
            if (leftValue == null) {
                return null;
            }
            Object rightValue = TypeUtils.readNativeValue((Type)valueType, (Block)rightMapBlock, (int)((Integer)entry.getValue()));
            if (rightValue == null) {
                return null;
            }
            try {
                Boolean result = valueEqualsFunction.invoke(leftValue, rightValue);
                if (result == null) {
                    return null;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return true;
    }

    private static final class KeyWrapper {
        private final Object key;
        private final MethodHandle hashCode;
        private final MethodHandle equals;

        public KeyWrapper(Object key, MethodHandle equals, MethodHandle hashCode) {
            this.key = key;
            this.equals = equals;
            this.hashCode = hashCode;
        }

        public int hashCode() {
            try {
                return Long.hashCode(this.hashCode.invoke(this.key));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            KeyWrapper other = (KeyWrapper)obj;
            try {
                return this.equals.invoke(this.key, other.key);
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
    }
}

