/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class MapKeys
extends SqlScalarFunction {
    public static final MapKeys MAP_KEYS = new MapKeys();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapKeys.class, "getKeys", Type.class, Block.class);

    public MapKeys() {
        super("map_keys", (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "array(K)", (List<String>)ImmutableList.of((Object)"map(K,V)"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Returns the keys of the given map(K,V) as an array";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"map_keys expects only one argument");
        Type keyType = types.get("K");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(keyType);
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)false), methodHandle, this.isDeterministic());
    }

    public static Block getKeys(Type keyType, Block block) {
        BlockBuilder blockBuilder = keyType.createBlockBuilder(new BlockBuilderStatus(), block.getPositionCount() / 2);
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            keyType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }
}

