/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerInfo;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;

public class HttpLocationFactory
implements LocationFactory {
    private final NodeManager nodeManager;
    private final URI baseUri;

    @Inject
    public HttpLocationFactory(NodeManager nodeManager, HttpServerInfo httpServerInfo) {
        this(nodeManager, httpServerInfo.getHttpUri());
    }

    public HttpLocationFactory(NodeManager nodeManager, URI baseUri) {
        this.nodeManager = nodeManager;
        this.baseUri = baseUri;
    }

    @Override
    public URI createQueryLocation(QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)this.baseUri).appendPath("/v1/query").appendPath(queryId.toString()).build();
    }

    @Override
    public URI createStageLocation(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)this.baseUri).appendPath("v1/stage").appendPath(stageId.toString()).build();
    }

    @Override
    public URI createLocalTaskLocation(TaskId taskId) {
        return this.createTaskLocation(this.nodeManager.getCurrentNode(), taskId);
    }

    @Override
    public URI createTaskLocation(Node node, TaskId taskId) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(taskId, "taskId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)node.getHttpUri()).appendPath("/v1/task").appendPath(taskId.toString()).build();
    }

    @Override
    public URI createMemoryInfoLocation(Node node) {
        Objects.requireNonNull(node, "node is null");
        return HttpUriBuilder.uriBuilderFrom((URI)node.getHttpUri()).appendPath("/v1/memory").build();
    }
}

