/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.Session;
import com.facebook.presto.TaskSource;
import com.facebook.presto.execution.BufferInfo;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.PageBufferInfo;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SharedBufferInfo;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.server.Backoff;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.SetMultimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonBodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.io.EOFException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

public final class HttpRemoteTask
implements RemoteTask {
    private static final Logger log = Logger.get(HttpRemoteTask.class);
    private static final Duration MAX_CLEANUP_RETRY_TIME = new Duration(2.0, TimeUnit.MINUTES);
    private final TaskId taskId;
    private final int partition;
    private final Session session;
    private final String nodeId;
    private final PlanFragment planFragment;
    private final AtomicLong nextSplitId = new AtomicLong();
    private final StateMachine<TaskInfo> taskInfo;
    @GuardedBy(value="this")
    private Future<?> currentRequest;
    @GuardedBy(value="this")
    private long currentRequestStartNanos;
    @GuardedBy(value="this")
    private final SetMultimap<PlanNodeId, ScheduledSplit> pendingSplits = HashMultimap.create();
    @GuardedBy(value="this")
    private volatile int pendingSourceSplitCount;
    @GuardedBy(value="this")
    private final Set<PlanNodeId> noMoreSplits = new HashSet<PlanNodeId>();
    @GuardedBy(value="this")
    private final AtomicReference<OutputBuffers> outputBuffers = new AtomicReference();
    private final boolean summarizeTaskInfo;
    private final Duration requestTimeout;
    private final ContinuousTaskInfoFetcher continuousTaskInfoFetcher;
    private final HttpClient httpClient;
    private final Executor executor;
    private final ScheduledExecutorService errorScheduledExecutor;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec;
    private final RequestErrorTracker updateErrorTracker;
    private final RequestErrorTracker getErrorTracker;
    private final AtomicBoolean needsUpdate = new AtomicBoolean(true);
    private final AtomicBoolean sendPlan = new AtomicBoolean(true);
    private final NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker;

    public HttpRemoteTask(Session session, TaskId taskId, String nodeId, int partition, URI location, PlanFragment planFragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, HttpClient httpClient, Executor executor, ScheduledExecutorService errorScheduledExecutor, Duration minErrorDuration, Duration refreshMaxWait, boolean summarizeTaskInfo, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(nodeId, "nodeId is null");
        Objects.requireNonNull(location, "location is null");
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)"partition is negative");
        Objects.requireNonNull(planFragment, "planFragment1 is null");
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        Objects.requireNonNull(taskUpdateRequestCodec, "taskUpdateRequestCodec is null");
        Objects.requireNonNull(partitionedSplitCountTracker, "partitionedSplitCountTracker is null");
        try (SetThreadName ignored = new SetThreadName("HttpRemoteTask-%s", new Object[]{taskId});){
            this.taskId = taskId;
            this.session = session;
            this.nodeId = nodeId;
            this.partition = partition;
            this.planFragment = planFragment;
            this.outputBuffers.set(outputBuffers);
            this.httpClient = httpClient;
            this.executor = executor;
            this.errorScheduledExecutor = errorScheduledExecutor;
            this.summarizeTaskInfo = summarizeTaskInfo;
            this.taskInfoCodec = taskInfoCodec;
            this.taskUpdateRequestCodec = taskUpdateRequestCodec;
            this.updateErrorTracker = new RequestErrorTracker(taskId, location, minErrorDuration, errorScheduledExecutor, "updating task");
            this.getErrorTracker = new RequestErrorTracker(taskId, location, minErrorDuration, errorScheduledExecutor, "getting info for task");
            this.partitionedSplitCountTracker = Objects.requireNonNull(partitionedSplitCountTracker, "partitionedSplitCountTracker is null");
            for (Map.Entry entry : Objects.requireNonNull(initialSplits, "initialSplits is null").entries()) {
                ScheduledSplit scheduledSplit = new ScheduledSplit(this.nextSplitId.getAndIncrement(), (Split)entry.getValue());
                this.pendingSplits.put(entry.getKey(), (Object)scheduledSplit);
            }
            if (initialSplits.containsKey((Object)planFragment.getPartitionedSource())) {
                this.pendingSourceSplitCount = initialSplits.get((Object)planFragment.getPartitionedSource()).size();
            }
            List bufferStates = (List)outputBuffers.getBuffers().keySet().stream().map(outputId -> new BufferInfo((TaskId)outputId, false, 0, 0L, PageBufferInfo.empty())).collect(ImmutableCollectors.toImmutableList());
            TaskStats taskStats = new TaskStats(DateTime.now(), null);
            this.taskInfo = new StateMachine<TaskInfo>("task " + taskId, executor, new TaskInfo(taskId, "", 0L, TaskState.PLANNED, location, DateTime.now(), new SharedBufferInfo(SharedBuffer.BufferState.OPEN, true, true, 0L, 0L, 0L, 0L, bufferStates), (Set<PlanNodeId>)ImmutableSet.of(), taskStats, (List<ExecutionFailureInfo>)ImmutableList.of(), true));
            long timeout = minErrorDuration.toMillis() / 3L;
            this.requestTimeout = new Duration((double)(timeout + refreshMaxWait.toMillis()), TimeUnit.MILLISECONDS);
            this.continuousTaskInfoFetcher = new ContinuousTaskInfoFetcher(refreshMaxWait);
            partitionedSplitCountTracker.setPartitionedSplitCount(this.getPartitionedSplitCount());
        }
    }

    @Override
    public TaskId getTaskId() {
        return this.taskId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public int getPartition() {
        return this.partition;
    }

    @Override
    public TaskInfo getTaskInfo() {
        return this.taskInfo.get();
    }

    @Override
    public void start() {
        try (SetThreadName ignored = new SetThreadName("HttpRemoteTask-%s", new Object[]{this.taskId});){
            this.scheduleUpdate();
            this.continuousTaskInfoFetcher.start();
        }
    }

    @Override
    public synchronized void addSplits(Multimap<PlanNodeId, Split> splitsBySource) {
        try (SetThreadName ignored = new SetThreadName("HttpRemoteTask-%s", new Object[]{this.taskId});){
            Objects.requireNonNull(splitsBySource, "splitsBySource is null");
            if (this.getTaskInfo().getState().isDone()) {
                return;
            }
            for (Map.Entry entry : splitsBySource.asMap().entrySet()) {
                PlanNodeId sourceId = (PlanNodeId)entry.getKey();
                Collection splits = (Collection)entry.getValue();
                Preconditions.checkState((!this.noMoreSplits.contains(sourceId) ? 1 : 0) != 0, (String)"noMoreSplits has already been set for %s", (Object[])new Object[]{sourceId});
                Preconditions.checkState((!this.noMoreSplits.contains(sourceId) ? 1 : 0) != 0, (String)"noMoreSplits has already been set for %s", (Object[])new Object[]{sourceId});
                int added = 0;
                for (Split split : splits) {
                    if (!this.pendingSplits.put((Object)sourceId, (Object)new ScheduledSplit(this.nextSplitId.getAndIncrement(), split))) continue;
                    ++added;
                }
                if (sourceId.equals(this.planFragment.getPartitionedSource())) {
                    this.pendingSourceSplitCount += added;
                    this.partitionedSplitCountTracker.setPartitionedSplitCount(this.getPartitionedSplitCount());
                }
                this.needsUpdate.set(true);
            }
            this.scheduleUpdate();
        }
    }

    @Override
    public synchronized void noMoreSplits(PlanNodeId sourceId) {
        if (this.noMoreSplits.add(sourceId)) {
            this.needsUpdate.set(true);
            this.scheduleUpdate();
        }
    }

    @Override
    public synchronized void setOutputBuffers(OutputBuffers newOutputBuffers) {
        if (this.getTaskInfo().getState().isDone()) {
            return;
        }
        if (newOutputBuffers.getVersion() > this.outputBuffers.get().getVersion()) {
            this.outputBuffers.set(newOutputBuffers);
            this.needsUpdate.set(true);
            this.scheduleUpdate();
        }
    }

    @Override
    public int getPartitionedSplitCount() {
        TaskInfo taskInfo = this.taskInfo.get();
        if (taskInfo.getState().isDone()) {
            return 0;
        }
        return this.getPendingSourceSplitCount() + taskInfo.getStats().getQueuedPartitionedDrivers() + taskInfo.getStats().getRunningPartitionedDrivers();
    }

    @Override
    public int getQueuedPartitionedSplitCount() {
        TaskInfo taskInfo = this.taskInfo.get();
        if (taskInfo.getState().isDone()) {
            return 0;
        }
        return this.getPendingSourceSplitCount() + taskInfo.getStats().getQueuedPartitionedDrivers();
    }

    private int getPendingSourceSplitCount() {
        return this.pendingSourceSplitCount;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<TaskInfo> stateChangeListener) {
        try (SetThreadName ignored = new SetThreadName("HttpRemoteTask-%s", new Object[]{this.taskId});){
            this.taskInfo.addStateChangeListener(stateChangeListener);
        }
    }

    @Override
    public CompletableFuture<TaskInfo> getStateChange(TaskInfo taskInfo) {
        return this.taskInfo.getStateChange(taskInfo);
    }

    private synchronized void updateTaskInfo(TaskInfo newValue) {
        this.updateTaskInfo(newValue, (List<TaskSource>)ImmutableList.of());
    }

    private synchronized void updateTaskInfo(TaskInfo newValue, List<TaskSource> sources) {
        if (newValue.getState().isDone()) {
            this.pendingSplits.clear();
            this.pendingSourceSplitCount = 0;
        }
        AtomicBoolean taskMismatch = new AtomicBoolean();
        this.taskInfo.setIf(newValue, oldValue -> {
            if (!Strings.isNullOrEmpty((String)oldValue.getTaskInstanceId()) && !oldValue.getTaskInstanceId().equals(newValue.getTaskInstanceId())) {
                taskMismatch.set(true);
                return false;
            }
            if (oldValue.getState().isDone()) {
                return false;
            }
            return newValue.getVersion() >= oldValue.getVersion();
        });
        if (taskMismatch.get()) {
            this.failTask(new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_MISMATCH, "Could not communicate with the remote task. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes."));
            this.abort();
        }
        for (TaskSource source : sources) {
            PlanNodeId planNodeId = source.getPlanNodeId();
            int removed = 0;
            for (ScheduledSplit split : source.getSplits()) {
                if (!this.pendingSplits.remove((Object)planNodeId, (Object)split)) continue;
                ++removed;
            }
            if (!planNodeId.equals(this.planFragment.getPartitionedSource())) continue;
            this.pendingSourceSplitCount -= removed;
        }
        this.partitionedSplitCountTracker.setPartitionedSplitCount(this.getPartitionedSplitCount());
    }

    private void scheduleUpdate() {
        this.executor.execute(this::sendUpdate);
    }

    private synchronized void sendUpdate() {
        HttpClient.HttpResponseFuture future;
        if (!this.needsUpdate.get() || this.taskInfo.get().getState().isDone()) {
            return;
        }
        if (this.currentRequest != null && Duration.nanosSince((long)this.currentRequestStartNanos).compareTo(this.requestTimeout) >= 0) {
            this.needsUpdate.set(true);
            this.currentRequest.cancel(true);
            this.currentRequest = null;
            this.currentRequestStartNanos = 0L;
        }
        if (this.currentRequest != null && !this.currentRequest.isDone()) {
            return;
        }
        ListenableFuture<?> errorRateLimit = this.updateErrorTracker.acquireRequestPermit();
        if (!errorRateLimit.isDone()) {
            errorRateLimit.addListener(this::sendUpdate, this.executor);
            return;
        }
        List<TaskSource> sources = this.getSources();
        Optional<PlanFragment> fragment = Optional.empty();
        if (this.sendPlan.get()) {
            fragment = Optional.of(this.planFragment);
        }
        TaskUpdateRequest updateRequest = new TaskUpdateRequest(this.session.toSessionRepresentation(), fragment, sources, this.outputBuffers.get());
        HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)this.taskInfo.get().getSelf());
        if (this.summarizeTaskInfo) {
            uriBuilder.addParameter("summarize", new String[0]);
        }
        Request request = Request.Builder.preparePost().setUri(uriBuilder.build()).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setBodyGenerator((BodyGenerator)JsonBodyGenerator.jsonBodyGenerator(this.taskUpdateRequestCodec, (Object)updateRequest)).build();
        this.updateErrorTracker.startRequest();
        this.currentRequest = future = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(this.taskInfoCodec));
        this.currentRequestStartNanos = System.nanoTime();
        this.needsUpdate.set(false);
        Futures.addCallback((ListenableFuture)future, new SimpleHttpResponseHandler<TaskInfo>(new UpdateResponseHandler(sources), request.getUri()), (Executor)this.executor);
    }

    private synchronized List<TaskSource> getSources() {
        return (List)Stream.concat(Stream.of(this.planFragment.getPartitionedSourceNode()), this.planFragment.getRemoteSourceNodes().stream()).filter(Objects::nonNull).map(PlanNode::getId).map(this::getSource).filter(Objects::nonNull).collect(ImmutableCollectors.toImmutableList());
    }

    private synchronized TaskSource getSource(PlanNodeId planNodeId) {
        Set splits = this.pendingSplits.get((Object)planNodeId);
        boolean noMoreSplits = this.noMoreSplits.contains(planNodeId);
        TaskSource element = null;
        if (!splits.isEmpty() || noMoreSplits) {
            element = new TaskSource(planNodeId, splits, noMoreSplits);
        }
        return element;
    }

    @Override
    public synchronized void cancel() {
        try (SetThreadName ignored = new SetThreadName("HttpRemoteTask-%s", new Object[]{this.taskId});){
            if (this.getTaskInfo().getState().isDone()) {
                return;
            }
            Preconditions.checkState((boolean)this.continuousTaskInfoFetcher.isRunning(), (Object)"Cannot cancel task when it is not running");
            URI uri = this.getTaskInfo().getSelf();
            if (uri == null) {
                return;
            }
            HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)uri).addParameter("abort", new String[]{"false"});
            if (this.summarizeTaskInfo) {
                uriBuilder.addParameter("summarize", new String[0]);
            }
            Request request = Request.Builder.prepareDelete().setUri(uriBuilder.build()).build();
            this.scheduleAsyncCleanupRequest(new Backoff(MAX_CLEANUP_RETRY_TIME), request, "cancel");
        }
    }

    @Override
    public synchronized void abort() {
        try (SetThreadName ignored = new SetThreadName("HttpRemoteTask-%s", new Object[]{this.taskId});){
            this.pendingSplits.clear();
            this.pendingSourceSplitCount = 0;
            this.partitionedSplitCountTracker.setPartitionedSplitCount(this.getPartitionedSplitCount());
            if (this.currentRequest != null) {
                this.currentRequest.cancel(true);
                this.currentRequest = null;
                this.currentRequestStartNanos = 0L;
            }
            TaskInfo taskInfo = this.getTaskInfo();
            URI uri = taskInfo.getSelf();
            this.updateTaskInfo(new TaskInfo(taskInfo.getTaskId(), taskInfo.getTaskInstanceId(), Long.MAX_VALUE, TaskState.ABORTED, uri, taskInfo.getLastHeartbeat(), taskInfo.getOutputBuffers(), taskInfo.getNoMoreSplits(), taskInfo.getStats(), (List<ExecutionFailureInfo>)ImmutableList.of(), taskInfo.isNeedsPlan()));
            HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)uri);
            if (this.summarizeTaskInfo) {
                uriBuilder.addParameter("summarize", new String[0]);
            }
            Request request = Request.Builder.prepareDelete().setUri(uriBuilder.build()).build();
            this.scheduleAsyncCleanupRequest(new Backoff(MAX_CLEANUP_RETRY_TIME), request, "abort");
        }
    }

    private void scheduleAsyncCleanupRequest(final Backoff cleanupBackoff, final Request request, final String action) {
        Futures.addCallback((ListenableFuture)this.httpClient.executeAsync(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler()), (FutureCallback)new FutureCallback<StatusResponseHandler.StatusResponse>(){

            public void onSuccess(StatusResponseHandler.StatusResponse result) {
            }

            public void onFailure(Throwable t) {
                if (t instanceof RejectedExecutionException) {
                    return;
                }
                if (cleanupBackoff.failure()) {
                    HttpRemoteTask.logError(t, "Unable to %s task at %s", new Object[]{action, request.getUri()});
                    return;
                }
                long delayNanos = cleanupBackoff.getBackoffDelayNanos();
                if (delayNanos == 0L) {
                    HttpRemoteTask.this.scheduleAsyncCleanupRequest(cleanupBackoff, request, action);
                } else {
                    HttpRemoteTask.this.errorScheduledExecutor.schedule(() -> HttpRemoteTask.this.scheduleAsyncCleanupRequest(cleanupBackoff, request, action), delayNanos, TimeUnit.NANOSECONDS);
                }
            }
        }, (Executor)this.executor);
    }

    private void failTask(Throwable cause) {
        TaskInfo taskInfo = this.getTaskInfo();
        if (!taskInfo.getState().isDone()) {
            log.debug(cause, "Remote task failed: %s", new Object[]{taskInfo.getSelf()});
        }
        this.updateTaskInfo(new TaskInfo(taskInfo.getTaskId(), taskInfo.getTaskInstanceId(), Long.MAX_VALUE, TaskState.FAILED, taskInfo.getSelf(), taskInfo.getLastHeartbeat(), taskInfo.getOutputBuffers(), taskInfo.getNoMoreSplits(), taskInfo.getStats(), (List<ExecutionFailureInfo>)ImmutableList.of((Object)Failures.toFailure(cause)), taskInfo.isNeedsPlan()));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getTaskInfo()).toString();
    }

    private static void logError(Throwable t, String format, Object ... args) {
        if (HttpRemoteTask.isExpectedError(t)) {
            log.error(format + ": %s", ObjectArrays.concat((Object[])args, (Object)t));
        } else {
            log.error(t, format, args);
        }
    }

    private static boolean isExpectedError(Throwable t) {
        while (t != null) {
            if (t instanceof SocketException || t instanceof SocketTimeoutException || t instanceof EOFException || t instanceof TimeoutException || t instanceof ServiceUnavailableException) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    private static class ServiceUnavailableException
    extends RuntimeException {
        public ServiceUnavailableException(URI uri) {
            super("Server returned SERVICE_UNAVAILABLE: " + uri);
        }
    }

    public static interface SimpleHttpResponseCallback<T> {
        public void success(T var1);

        public void failed(Throwable var1);

        public void fatal(Throwable var1);
    }

    @ThreadSafe
    private static class RequestErrorTracker {
        private final TaskId taskId;
        private final URI taskUri;
        private final ScheduledExecutorService scheduledExecutor;
        private final String jobDescription;
        private final Backoff backoff;
        private final Queue<Throwable> errorsSinceLastSuccess = new ConcurrentLinkedQueue<Throwable>();

        public RequestErrorTracker(TaskId taskId, URI taskUri, Duration minErrorDuration, ScheduledExecutorService scheduledExecutor, String jobDescription) {
            this.taskId = taskId;
            this.taskUri = taskUri;
            this.scheduledExecutor = scheduledExecutor;
            this.backoff = new Backoff(minErrorDuration);
            this.jobDescription = jobDescription;
        }

        public ListenableFuture<?> acquireRequestPermit() {
            long delayNanos = this.backoff.getBackoffDelayNanos();
            if (delayNanos == 0L) {
                return Futures.immediateFuture(null);
            }
            ListenableFutureTask futureTask = ListenableFutureTask.create(() -> null);
            this.scheduledExecutor.schedule((Runnable)futureTask, delayNanos, TimeUnit.NANOSECONDS);
            return futureTask;
        }

        public void startRequest() {
            if (this.backoff.getFailureCount() == 0L) {
                this.requestSucceeded();
            }
        }

        public void requestSucceeded() {
            this.backoff.success();
            this.errorsSinceLastSuccess.clear();
        }

        public void requestFailed(Throwable reason) throws PrestoException {
            if (reason instanceof CancellationException) {
                return;
            }
            if (reason instanceof RejectedExecutionException) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, reason);
            }
            if (HttpRemoteTask.isExpectedError(reason)) {
                log.warn("Error " + this.jobDescription + " %s: %s: %s", new Object[]{this.taskId, reason.getMessage(), this.taskUri});
            } else {
                log.warn(reason, "Error " + this.jobDescription + " %s: %s", new Object[]{this.taskId, this.taskUri});
            }
            if (this.errorsSinceLastSuccess.size() < 10) {
                this.errorsSinceLastSuccess.add(reason);
            }
            if (this.backoff.failure()) {
                PrestoException exception = new PrestoException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, String.format("%s (%s %s - %s failures, time since last success %s)", "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", this.jobDescription, this.taskUri, this.backoff.getFailureCount(), this.backoff.getTimeSinceLastSuccess().convertTo(TimeUnit.SECONDS)));
                this.errorsSinceLastSuccess.forEach(exception::addSuppressed);
                throw exception;
            }
        }
    }

    public static class SimpleHttpResponseHandler<T>
    implements FutureCallback<FullJsonResponseHandler.JsonResponse<T>> {
        private final SimpleHttpResponseCallback<T> callback;
        private final URI uri;

        public SimpleHttpResponseHandler(SimpleHttpResponseCallback<T> callback, URI uri) {
            this.callback = callback;
            this.uri = uri;
        }

        public void onSuccess(FullJsonResponseHandler.JsonResponse<T> response) {
            try {
                if (response.getStatusCode() == HttpStatus.OK.code() && response.hasValue()) {
                    this.callback.success(response.getValue());
                } else if (response.getStatusCode() == HttpStatus.SERVICE_UNAVAILABLE.code()) {
                    this.callback.failed(new ServiceUnavailableException(this.uri));
                } else {
                    Throwable cause = response.getException();
                    if (cause == null) {
                        cause = response.getStatusCode() == HttpStatus.OK.code() ? new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, String.format("Expected response from %s is empty", this.uri)) : new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, String.format("Expected response code from %s to be %s, but was %s: %s%n%s", this.uri, HttpStatus.OK.code(), response.getStatusCode(), response.getStatusMessage(), response.getResponseBody()));
                    }
                    this.callback.fatal(cause);
                }
            }
            catch (Throwable t) {
                this.callback.fatal(t);
            }
        }

        public void onFailure(Throwable t) {
            this.callback.failed(t);
        }
    }

    private class ContinuousTaskInfoFetcher
    implements SimpleHttpResponseCallback<TaskInfo> {
        private final Duration refreshMaxWait;
        @GuardedBy(value="this")
        private boolean running;
        @GuardedBy(value="this")
        private ListenableFuture<FullJsonResponseHandler.JsonResponse<TaskInfo>> future;

        public ContinuousTaskInfoFetcher(Duration refreshMaxWait) {
            this.refreshMaxWait = refreshMaxWait;
        }

        public synchronized void start() {
            if (this.running) {
                return;
            }
            this.running = true;
            this.scheduleNextRequest();
        }

        public synchronized void stop() {
            this.running = false;
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }

        private synchronized void scheduleNextRequest() {
            TaskInfo taskInfo = (TaskInfo)HttpRemoteTask.this.taskInfo.get();
            if (!this.running || taskInfo.getState().isDone()) {
                return;
            }
            if (this.future != null && !this.future.isDone()) {
                log.error("Can not reschedule update because an update is already running");
                return;
            }
            ListenableFuture<?> errorRateLimit = HttpRemoteTask.this.getErrorTracker.acquireRequestPermit();
            if (!errorRateLimit.isDone()) {
                errorRateLimit.addListener(this::scheduleNextRequest, HttpRemoteTask.this.executor);
                return;
            }
            HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)taskInfo.getSelf());
            if (HttpRemoteTask.this.summarizeTaskInfo) {
                uriBuilder.addParameter("summarize", new String[0]);
            }
            Request request = Request.Builder.prepareGet().setUri(uriBuilder.build()).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setHeader("X-Presto-Current-State", taskInfo.getState().toString()).setHeader("X-Presto-Max-Wait", this.refreshMaxWait.toString()).build();
            HttpRemoteTask.this.getErrorTracker.startRequest();
            this.future = HttpRemoteTask.this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler((JsonCodec)HttpRemoteTask.this.taskInfoCodec));
            Futures.addCallback(this.future, new SimpleHttpResponseHandler<TaskInfo>(this, request.getUri()), (Executor)HttpRemoteTask.this.executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void success(TaskInfo value) {
            try (SetThreadName ignored = new SetThreadName("ContinuousTaskInfoFetcher-%s", new Object[]{HttpRemoteTask.this.taskId});){
                ContinuousTaskInfoFetcher continuousTaskInfoFetcher = this;
                synchronized (continuousTaskInfoFetcher) {
                    this.future = null;
                }
                try {
                    HttpRemoteTask.this.updateTaskInfo(value, (List)ImmutableList.of());
                    HttpRemoteTask.this.getErrorTracker.requestSucceeded();
                }
                finally {
                    this.scheduleNextRequest();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable cause) {
            try (SetThreadName ignored = new SetThreadName("ContinuousTaskInfoFetcher-%s", new Object[]{HttpRemoteTask.this.taskId});){
                ContinuousTaskInfoFetcher continuousTaskInfoFetcher = this;
                synchronized (continuousTaskInfoFetcher) {
                    this.future = null;
                }
                try {
                    TaskInfo taskInfo = HttpRemoteTask.this.getTaskInfo();
                    if (!taskInfo.getState().isDone()) {
                        HttpRemoteTask.this.getErrorTracker.requestFailed(cause);
                    }
                }
                catch (Error e) {
                    HttpRemoteTask.this.failTask(e);
                    HttpRemoteTask.this.abort();
                    throw e;
                }
                catch (RuntimeException e) {
                    HttpRemoteTask.this.failTask(e);
                    HttpRemoteTask.this.abort();
                }
                finally {
                    this.scheduleNextRequest();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fatal(Throwable cause) {
            try (SetThreadName ignored = new SetThreadName("ContinuousTaskInfoFetcher-%s", new Object[]{HttpRemoteTask.this.taskId});){
                ContinuousTaskInfoFetcher continuousTaskInfoFetcher = this;
                synchronized (continuousTaskInfoFetcher) {
                    this.future = null;
                }
                HttpRemoteTask.this.failTask(cause);
            }
        }

        public synchronized boolean isRunning() {
            return this.running;
        }
    }

    private class UpdateResponseHandler
    implements SimpleHttpResponseCallback<TaskInfo> {
        private final List<TaskSource> sources;

        private UpdateResponseHandler(List<TaskSource> sources) {
            this.sources = ImmutableList.copyOf((Collection)Objects.requireNonNull(sources, "sources is null"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void success(TaskInfo value) {
            try (SetThreadName ignored = new SetThreadName("UpdateResponseHandler-%s", new Object[]{HttpRemoteTask.this.taskId});){
                try {
                    HttpRemoteTask httpRemoteTask = HttpRemoteTask.this;
                    synchronized (httpRemoteTask) {
                        HttpRemoteTask.this.currentRequest = null;
                        HttpRemoteTask.this.sendPlan.set(value.isNeedsPlan());
                    }
                    HttpRemoteTask.this.updateTaskInfo(value, this.sources);
                    HttpRemoteTask.this.updateErrorTracker.requestSucceeded();
                }
                finally {
                    HttpRemoteTask.this.sendUpdate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable cause) {
            try (SetThreadName ignored = new SetThreadName("UpdateResponseHandler-%s", new Object[]{HttpRemoteTask.this.taskId});){
                try {
                    HttpRemoteTask httpRemoteTask = HttpRemoteTask.this;
                    synchronized (httpRemoteTask) {
                        HttpRemoteTask.this.currentRequest = null;
                    }
                    HttpRemoteTask.this.needsUpdate.set(true);
                    TaskInfo taskInfo = HttpRemoteTask.this.getTaskInfo();
                    if (!taskInfo.getState().isDone()) {
                        HttpRemoteTask.this.updateErrorTracker.requestFailed(cause);
                    }
                }
                catch (Error e) {
                    HttpRemoteTask.this.failTask(e);
                    HttpRemoteTask.this.abort();
                    throw e;
                }
                catch (RuntimeException e) {
                    HttpRemoteTask.this.failTask(e);
                    HttpRemoteTask.this.abort();
                }
                finally {
                    HttpRemoteTask.this.sendUpdate();
                }
            }
        }

        @Override
        public void fatal(Throwable cause) {
            try (SetThreadName ignored = new SetThreadName("UpdateResponseHandler-%s", new Object[]{HttpRemoteTask.this.taskId});){
                HttpRemoteTask.this.failTask(cause);
            }
        }
    }
}

