/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.util.ImmutableCollectors;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class SampledSplitSource
implements SplitSource {
    private final SplitSource splitSource;
    private final double sampleRatio;

    public SampledSplitSource(SplitSource splitSource, double sampleRatio) {
        this.splitSource = Objects.requireNonNull(splitSource, "dataSource is null");
        this.sampleRatio = sampleRatio;
    }

    @Override
    @Nullable
    public String getDataSourceName() {
        return this.splitSource.getDataSourceName();
    }

    @Override
    public CompletableFuture<List<Split>> getNextBatch(int maxSize) {
        return this.splitSource.getNextBatch(maxSize).thenApply(splits -> splits.stream().filter(input -> ThreadLocalRandom.current().nextDouble() < this.sampleRatio).collect(ImmutableCollectors.toImmutableList()));
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    @Override
    public boolean isFinished() {
        return this.splitSource.isFinished();
    }
}

