/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.split.ConnectorAwareSplitSource;
import com.facebook.presto.split.SplitSource;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SplitManager {
    private final ConcurrentMap<String, ConnectorSplitManager> splitManagers = new ConcurrentHashMap<String, ConnectorSplitManager>();

    public void addConnectorSplitManager(String connectorId, ConnectorSplitManager connectorSplitManager) {
        Preconditions.checkState((this.splitManagers.putIfAbsent(connectorId, connectorSplitManager) == null ? 1 : 0) != 0, (String)"SplitManager for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public SplitSource getSplits(Session session, TableLayoutHandle layout) {
        String connectorId = layout.getConnectorId();
        ConnectorSplitManager splitManager = this.getConnectorSplitManager(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        ConnectorSplitSource source = splitManager.getSplits(layout.getTransactionHandle(), connectorSession, layout.getConnectorHandle());
        return new ConnectorAwareSplitSource(connectorId, layout.getTransactionHandle(), source);
    }

    private ConnectorSplitManager getConnectorSplitManager(String connectorId) {
        ConnectorSplitManager result = (ConnectorSplitManager)this.splitManagers.get(connectorId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No split manager for connector '%s'", (Object[])new Object[]{connectorId});
        return result;
    }
}

