/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.AggregateExtractor;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.WindowFunctionExtractor;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

class AggregationAnalyzer {
    private final List<Integer> fieldIndexes;
    private final List<Expression> expressions;
    private final Metadata metadata;
    private final Set<Expression> columnReferences;
    private final RelationType tupleDescriptor;

    public AggregationAnalyzer(List<FieldOrExpression> groupByExpressions, Metadata metadata, RelationType tupleDescriptor, Set<Expression> columnReferences) {
        Objects.requireNonNull(groupByExpressions, "groupByExpressions is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(tupleDescriptor, "tupleDescriptor is null");
        Objects.requireNonNull(columnReferences, "columnReferences is null");
        this.tupleDescriptor = tupleDescriptor;
        this.metadata = metadata;
        this.columnReferences = ImmutableSet.copyOf(columnReferences);
        this.expressions = (List)groupByExpressions.stream().filter(FieldOrExpression::isExpression).map(FieldOrExpression::getExpression).collect(ImmutableCollectors.toImmutableList());
        ImmutableList.Builder fieldIndexes = ImmutableList.builder();
        fieldIndexes.addAll(groupByExpressions.stream().filter(FieldOrExpression::isFieldReference).map(FieldOrExpression::getFieldIndex).iterator());
        for (Expression expression : Iterables.filter(this.expressions, columnReferences::contains)) {
            QualifiedName name = expression instanceof QualifiedNameReference ? ((QualifiedNameReference)expression).getName() : DereferenceExpression.getQualifiedName((DereferenceExpression)Types.checkType(expression, DereferenceExpression.class, "expression"));
            List<Field> fields = tupleDescriptor.resolveFields(name);
            Preconditions.checkState((fields.size() <= 1 ? 1 : 0) != 0, (String)"Found more than one field for name '%s': %s", (Object[])new Object[]{name, fields});
            if (fields.size() != 1) continue;
            Field field = (Field)Iterables.getOnlyElement(fields);
            fieldIndexes.add((Object)tupleDescriptor.indexOf(field));
        }
        this.fieldIndexes = fieldIndexes.build();
    }

    public boolean analyze(int fieldIndex) {
        return Iterables.any(this.fieldIndexes, (Predicate)Predicates.equalTo((Object)fieldIndex));
    }

    public void analyze(Expression expression) {
        Visitor visitor = new Visitor();
        if (!visitor.process((Node)expression, null).booleanValue()) {
            throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "'%s' must be an aggregate expression or appear in GROUP BY clause", expression);
        }
    }

    private class Visitor
    extends AstVisitor<Boolean, Void> {
        private Visitor() {
        }

        protected Boolean visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("aggregation analysis not yet implemented for: " + node.getClass().getName());
        }

        protected Boolean visitAtTimeZone(AtTimeZone node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitSubqueryExpression(SubqueryExpression node, Void context) {
            return true;
        }

        protected Boolean visitSubscriptExpression(SubscriptExpression node, Void context) {
            return this.process((Node)node.getBase(), context) != false && this.process((Node)node.getIndex(), context) != false;
        }

        protected Boolean visitArrayConstructor(ArrayConstructor node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitCast(Cast node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitCoalesceExpression(CoalesceExpression node, Void context) {
            return node.getOperands().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
            return this.process((Node)node.getFirst(), context) != false && this.process((Node)node.getSecond(), context) != false;
        }

        protected Boolean visitExtract(Extract node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
            return this.process((Node)node.getMin(), context) != false && this.process((Node)node.getValue(), context) != false && this.process((Node)node.getMax(), context) != false;
        }

        protected Boolean visitCurrentTime(CurrentTime node, Void context) {
            return true;
        }

        protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitLiteral(Literal node, Void context) {
            return true;
        }

        protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLikePredicate(LikePredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getPattern(), context) != false;
        }

        protected Boolean visitInListExpression(InListExpression node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitInPredicate(InPredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getValueList(), context) != false;
        }

        protected Boolean visitFunctionCall(FunctionCall node, Void context) {
            if (!node.getWindow().isPresent() && AggregationAnalyzer.this.metadata.isAggregationFunction(node.getName())) {
                AggregateExtractor aggregateExtractor = new AggregateExtractor(AggregationAnalyzer.this.metadata);
                WindowFunctionExtractor windowExtractor = new WindowFunctionExtractor();
                for (Expression argument : node.getArguments()) {
                    aggregateExtractor.process((Node)argument, null);
                    windowExtractor.process((Node)argument, null);
                }
                if (!aggregateExtractor.getAggregates().isEmpty()) {
                    throw new SemanticException(SemanticErrorCode.NESTED_AGGREGATION, (Node)node, "Cannot nest aggregations inside aggregation '%s': %s", node.getName(), aggregateExtractor.getAggregates());
                }
                if (!windowExtractor.getWindowFunctions().isEmpty()) {
                    throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside aggregation '%s': %s", node.getName(), windowExtractor.getWindowFunctions());
                }
                return true;
            }
            if (node.getWindow().isPresent() && !this.process((Node)node.getWindow().get(), context).booleanValue()) {
                return false;
            }
            return node.getArguments().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        public Boolean visitWindow(Window node, Void context) {
            for (Expression expression : node.getPartitionBy()) {
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "PARTITION BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            for (SortItem sortItem : node.getOrderBy()) {
                Expression expression = sortItem.getSortKey();
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "ORDER BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            if (node.getFrame().isPresent()) {
                this.process((Node)node.getFrame().get(), context);
            }
            return true;
        }

        public Boolean visitWindowFrame(WindowFrame node, Void context) {
            Expression endValue;
            Optional start = node.getStart().getValue();
            if (start.isPresent() && !this.process((Node)start.get(), context).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)start.get(), "Window frame start must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            if (node.getEnd().isPresent() && ((FrameBound)node.getEnd().get()).getValue().isPresent() && !this.process((Node)(endValue = (Expression)((FrameBound)node.getEnd().get()).getValue().get()), context).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)endValue, "Window frame end must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            return true;
        }

        protected Boolean visitQualifiedNameReference(QualifiedNameReference node, Void context) {
            return this.isField(node.getName());
        }

        protected Boolean visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (AggregationAnalyzer.this.columnReferences.contains(node)) {
                return this.isField(DereferenceExpression.getQualifiedName((DereferenceExpression)node));
            }
            return this.process((Node)node.getBase(), context);
        }

        private Boolean isField(QualifiedName qualifiedName) {
            List<Field> fields = AggregationAnalyzer.this.tupleDescriptor.resolveFields(qualifiedName);
            Preconditions.checkState((!fields.isEmpty() ? 1 : 0) != 0, (String)"No fields for name '%s'", (Object[])new Object[]{qualifiedName});
            Preconditions.checkState((fields.size() <= 1 ? 1 : 0) != 0, (String)"Found more than one field for name '%s': %s", (Object[])new Object[]{qualifiedName, fields});
            Field field = (Field)Iterables.getOnlyElement(fields);
            return AggregationAnalyzer.this.fieldIndexes.contains(AggregationAnalyzer.this.tupleDescriptor.indexOf(field));
        }

        protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitNotExpression(NotExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder expressions = ImmutableList.builder().add((Object)node.getCondition()).add((Object)node.getTrueValue());
            if (node.getFalseValue().isPresent()) {
                expressions.add(node.getFalseValue().get());
            }
            return expressions.build().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            if (!this.process((Node)node.getOperand(), context).booleanValue()) {
                return false;
            }
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            if (node.getDefaultValue().isPresent() && !this.process((Node)node.getDefaultValue().get(), context).booleanValue()) {
                return false;
            }
            return true;
        }

        protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            return !node.getDefaultValue().isPresent() || this.process((Node)node.getDefaultValue().get(), context) != false;
        }

        protected Boolean visitTryExpression(TryExpression node, Void context) {
            return this.process((Node)node.getInnerExpression(), context);
        }

        public Boolean visitRow(Row node, Void context) {
            return node.getItems().stream().allMatch(item -> this.process((Node)item, context));
        }

        public Boolean process(Node node, @Nullable Void context) {
            if (AggregationAnalyzer.this.expressions.stream().anyMatch(arg_0 -> ((Node)node).equals(arg_0))) {
                return true;
            }
            return (Boolean)super.process(node, (Object)context);
        }
    }
}

