/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.QualifiedName;
import java.util.Objects;
import java.util.Optional;

public class Field {
    private final Optional<QualifiedName> relationAlias;
    private final Optional<String> name;
    private final Type type;
    private final boolean hidden;

    public static Field newUnqualified(String name, Type type) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        return new Field(Optional.empty(), Optional.of(name), type, false);
    }

    public static Field newUnqualified(Optional<String> name, Type type) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        return new Field(Optional.empty(), name, type, false);
    }

    public static Field newQualified(QualifiedName relationAlias, Optional<String> name, Type type, boolean hidden) {
        Objects.requireNonNull(relationAlias, "relationAlias is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        return new Field(Optional.of(relationAlias), name, type, hidden);
    }

    public Field(Optional<QualifiedName> relationAlias, Optional<String> name, Type type, boolean hidden) {
        Objects.requireNonNull(relationAlias, "relationAlias is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        this.relationAlias = relationAlias;
        this.name = name;
        this.type = type;
        this.hidden = hidden;
    }

    public Optional<QualifiedName> getRelationAlias() {
        return this.relationAlias;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean matchesPrefix(Optional<QualifiedName> prefix) {
        return !prefix.isPresent() || this.relationAlias.isPresent() && this.relationAlias.get().hasSuffix(prefix.get());
    }

    public boolean canResolve(QualifiedName name) {
        if (!this.name.isPresent()) {
            return false;
        }
        return this.matchesPrefix(name.getPrefix()) && this.name.get().equalsIgnoreCase(name.getSuffix());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.relationAlias.isPresent()) {
            result.append(this.relationAlias.get()).append(".");
        }
        result.append(this.name.orElse("<anonymous>")).append(":").append(this.type);
        return result.toString();
    }
}

