/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanPrinter;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class QueryExplainer {
    private final List<PlanOptimizer> planOptimizers;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final boolean experimentalSyntaxEnabled;
    private final Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask;

    @Inject
    public QueryExplainer(List<PlanOptimizer> planOptimizers, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask, FeaturesConfig featuresConfig) {
        this(planOptimizers, metadata, accessControl, sqlParser, dataDefinitionTask, featuresConfig.isExperimentalSyntaxEnabled());
    }

    public QueryExplainer(List<PlanOptimizer> planOptimizers, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask, boolean experimentalSyntaxEnabled) {
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
        this.dataDefinitionTask = ImmutableMap.copyOf(Objects.requireNonNull(dataDefinitionTask, "dataDefinitionTask is null"));
    }

    public String getPlan(Session session, Statement statement, ExplainType.Type planType) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task);
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement);
                return PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata, session);
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement);
                return PlanPrinter.textDistributedPlan(subPlan, this.metadata, session);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    private static <T extends Statement> String explainTask(Statement statement, DataDefinitionTask<T> task) {
        return task.explain(statement);
    }

    public String getGraphvizPlan(Session session, Statement statement, ExplainType.Type planType) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task);
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement);
                return PlanPrinter.graphvizLogicalPlan(plan.getRoot(), plan.getTypes());
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement);
                return PlanPrinter.graphvizDistributedPlan(subPlan);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    private Plan getLogicalPlan(Session session, Statement statement) {
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(this), this.experimentalSyntaxEnabled);
        Analysis analysis = analyzer.analyze(statement);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, this.planOptimizers, idAllocator, this.metadata);
        return logicalPlanner.plan(analysis);
    }

    private SubPlan getDistributedPlan(Session session, Statement statement) {
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(this), this.experimentalSyntaxEnabled);
        Analysis analysis = analyzer.analyze(statement);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, this.planOptimizers, idAllocator, this.metadata);
        Plan plan = logicalPlanner.plan(analysis);
        return new PlanFragmenter().createSubPlans(plan);
    }
}

