/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import java.util.ArrayList;
import java.util.List;

public class FunctionCallCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        FunctionRegistry registry = context.getRegistry();
        ScalarFunctionImplementation function = registry.getScalarFunctionImplementation(signature);
        ArrayList<BytecodeNode> argumentsBytecode = new ArrayList<BytecodeNode>();
        for (RowExpression argument : arguments) {
            argumentsBytecode.add(context.generate(argument));
        }
        return context.generateCall(signature.getName(), function, argumentsBytecode);
    }
}

