/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public final class IsolatedClass {
    private IsolatedClass() {
    }

    public static <T> Class<? extends T> isolateClass(DynamicClassLoader dynamicClassLoader, Class<T> publicBaseClass, Class<? extends T> implementationClass, Class<?> ... additionalClasses) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)implementationClass.getName(), (Object)IsolatedClass.getBytecode(implementationClass));
        for (Class<?> additionalClass : additionalClasses) {
            builder.put((Object)additionalClass.getName(), (Object)IsolatedClass.getBytecode(additionalClass));
        }
        Map isolatedClasses = dynamicClassLoader.defineClasses((Map)builder.build());
        Class isolatedClass = (Class)isolatedClasses.get(implementationClass.getName());
        Preconditions.checkArgument((isolatedClass != null ? 1 : 0) != 0, (String)"Could load class %s", (Object[])new Object[]{implementationClass.getName()});
        Preconditions.checkArgument((boolean)publicBaseClass.isAssignableFrom(isolatedClass), (String)"Error isolating class %s, newly loaded class is not a sub type of %s", (Object[])new Object[]{implementationClass.getName(), publicBaseClass.getName()});
        Preconditions.checkState((isolatedClass != implementationClass ? 1 : 0) != 0, (Object)"Isolation failed");
        return isolatedClass.asSubclass(publicBaseClass);
    }

    private static byte[] getBytecode(Class<?> clazz) {
        InputStream stream = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (String)"Could not obtain byte code for class %s", (Object[])new Object[]{clazz.getName()});
        try {
            return ByteStreams.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

