/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;

public class DesugaringRewriter
extends ExpressionRewriter<Void> {
    private final IdentityHashMap<Expression, Type> expressionTypes;

    public DesugaringRewriter(IdentityHashMap<Expression, Type> expressionTypes) {
        this.expressionTypes = Objects.requireNonNull(expressionTypes, "expressionTypes is null");
    }

    public Expression rewriteAtTimeZone(AtTimeZone node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
        Type type = this.expressionTypes.get(value);
        if (type.equals(TimeType.TIME)) {
            value = new Cast(value, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.getDisplayName());
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            value = new Cast(value, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.getDisplayName());
        }
        return new FunctionCall(QualifiedName.of((String)"at_timezone", (String[])new String[0]), (List)ImmutableList.of((Object)value, (Object)treeRewriter.rewrite(node.getTimeZone(), (Object)context)));
    }
}

