/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.Node;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public class NodePartitionMap {
    private final Map<Integer, Node> partitionToNode;
    private final int[] bucketToPartition;
    private final ToIntFunction<Split> splitToBucket;

    public NodePartitionMap(Map<Integer, Node> partitionToNode, ToIntFunction<Split> splitToBucket) {
        this.partitionToNode = ImmutableMap.copyOf(Objects.requireNonNull(partitionToNode, "partitionToNode is null"));
        this.bucketToPartition = IntStream.range(0, partitionToNode.size()).toArray();
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
    }

    public NodePartitionMap(Map<Integer, Node> partitionToNode, int[] bucketToPartition, ToIntFunction<Split> splitToBucket) {
        this.bucketToPartition = Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
        this.partitionToNode = ImmutableMap.copyOf(Objects.requireNonNull(partitionToNode, "partitionToNode is null"));
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
    }

    public Map<Integer, Node> getPartitionToNode() {
        return this.partitionToNode;
    }

    public int[] getBucketToPartition() {
        return this.bucketToPartition;
    }

    public Node getNode(Split split) {
        int bucket = this.splitToBucket.applyAsInt(split);
        int partition = this.bucketToPartition[bucket];
        return Objects.requireNonNull(this.partitionToNode.get(partition));
    }
}

