/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Map<Symbol, Type> symbols;
    private final PartitioningHandle partitioning;
    private final PlanNodeId partitionedSource;
    private final List<Type> types;
    private final PlanNode partitionedSourceNode;
    private final List<RemoteSourceNode> remoteSourceNodes;
    private final PartitionFunctionBinding partitionFunction;

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="symbols") Map<Symbol, Type> symbols, @JsonProperty(value="partitioning") PartitioningHandle partitioning, @JsonProperty(value="partitionedSource") PlanNodeId partitionedSource, @JsonProperty(value="partitionFunction") PartitionFunctionBinding partitionFunction) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.root = Objects.requireNonNull(root, "root is null");
        this.symbols = Objects.requireNonNull(symbols, "symbols is null");
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.partitionedSource = partitionedSource;
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(root.getOutputSymbols()).containsAll(partitionFunction.getOutputLayout()), (String)"Root node outputs (%s) does not include all fragment outputs (%s)", (Object[])new Object[]{root.getOutputSymbols(), partitionFunction.getOutputLayout()});
        this.types = (List)partitionFunction.getOutputLayout().stream().map(symbols::get).collect(ImmutableCollectors.toImmutableList());
        this.partitionedSourceNode = PlanFragment.findSource(root, partitionedSource);
        ImmutableList.Builder remoteSourceNodes = ImmutableList.builder();
        PlanFragment.findRemoteSourceNodes(root, (ImmutableList.Builder<RemoteSourceNode>)remoteSourceNodes);
        this.remoteSourceNodes = remoteSourceNodes.build();
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Map<Symbol, Type> getSymbols() {
        return this.symbols;
    }

    @JsonProperty
    public PartitioningHandle getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public PlanNodeId getPartitionedSource() {
        return this.partitionedSource;
    }

    @JsonProperty
    public PartitionFunctionBinding getPartitionFunction() {
        return this.partitionFunction;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public PlanNode getPartitionedSourceNode() {
        return this.partitionedSourceNode;
    }

    public boolean isLeaf() {
        return this.remoteSourceNodes.isEmpty();
    }

    public List<RemoteSourceNode> getRemoteSourceNodes() {
        return this.remoteSourceNodes;
    }

    private static PlanNode findSource(PlanNode node, PlanNodeId nodeId) {
        if (node.getId().equals(nodeId)) {
            return node;
        }
        return node.getSources().stream().map(source -> PlanFragment.findSource(source, nodeId)).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static void findRemoteSourceNodes(PlanNode node, ImmutableList.Builder<RemoteSourceNode> builder) {
        for (PlanNode source : node.getSources()) {
            PlanFragment.findRemoteSourceNodes(source, builder);
        }
        if (node instanceof RemoteSourceNode) {
            builder.add((Object)((RemoteSourceNode)node));
        }
    }

    public PlanFragment withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PlanFragment(this.id, this.root, this.symbols, this.partitioning, this.partitionedSource, this.partitionFunction.withBucketToPartition(bucketToPartition));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("partitioning", (Object)this.partitioning).add("partitionedSource", (Object)this.partitionedSource).add("partitionFunction", (Object)this.partitionFunction).toString();
    }
}

