/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolExtractor;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PlanFragmenter {
    public SubPlan createSubPlans(Plan plan) {
        Fragmenter fragmenter = new Fragmenter(plan.getSymbolAllocator().getTypes());
        FragmentProperties properties = new FragmentProperties(new PartitionFunctionBinding(SystemPartitioningHandle.SINGLE_DISTRIBUTION, plan.getRoot().getOutputSymbols(), (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of())).setSingleNodeDistribution();
        PlanNode root = SimplePlanRewriter.rewriteWith(fragmenter, plan.getRoot(), properties);
        SubPlan result = fragmenter.buildRootFragment(root, properties);
        result.sanityCheck();
        return result;
    }

    private static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private final PartitionFunctionBinding partitionFunction;
        private Optional<PartitioningHandle> partitioningHandle = Optional.empty();
        private PlanNodeId distributeBy;

        public FragmentProperties(PartitionFunctionBinding partitionFunction) {
            this.partitionFunction = partitionFunction;
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isSingleNode()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object[])new Object[]{SystemPartitioningHandle.SINGLE_DISTRIBUTION, this.partitioningHandle});
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.SINGLE_DISTRIBUTION);
            return this;
        }

        public FragmentProperties setDistribution(PartitioningHandle distribution) {
            if (this.partitioningHandle.isPresent() && !this.partitioningHandle.get().equals(distribution) && !this.partitioningHandle.get().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                Preconditions.checkState((boolean)this.partitioningHandle.get().isSingleNode(), (String)"Cannot set distribution to %s. Already set to %s", (Object[])new Object[]{distribution, this.partitioningHandle});
                return this;
            }
            this.partitioningHandle = Optional.of(distribution);
            return this;
        }

        public FragmentProperties setCoordinatorOnlyDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isCoordinatorOnly()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() || this.partitioningHandle.get().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object[])new Object[]{SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, this.partitioningHandle});
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION);
            return this;
        }

        public FragmentProperties setSourceDistribution(PlanNodeId source) {
            if (this.partitioningHandle.isPresent()) {
                PartitioningHandle partitioningHandle = this.partitioningHandle.get();
                if (partitioningHandle.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                    Preconditions.checkState((this.distributeBy == null || this.distributeBy == source ? 1 : 0) != 0, (Object)"Cannot overwrite partitioned source");
                } else {
                    Preconditions.checkState((partitioningHandle.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || partitioningHandle.equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite distribution with %s (currently set to %s)", (Object[])new Object[]{SystemPartitioningHandle.SOURCE_DISTRIBUTION, partitioningHandle});
                    return this;
                }
            }
            this.distributeBy = Objects.requireNonNull(source, "source is null");
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            return this;
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public PartitionFunctionBinding getPartitionFunction() {
            return this.partitionFunction;
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle.get();
        }

        public PlanNodeId getDistributeBy() {
            return this.distributeBy;
        }
    }

    private static class Fragmenter
    extends SimplePlanRewriter<FragmentProperties> {
        private static final int ROOT_FRAGMENT_ID = 0;
        private final Map<Symbol, Type> types;
        private int nextFragmentId = 1;

        public Fragmenter(Map<Symbol, Type> types) {
            this.types = types;
        }

        public SubPlan buildRootFragment(PlanNode root, FragmentProperties properties) {
            return this.buildFragment(root, properties, new PlanFragmentId(String.valueOf(0)));
        }

        private PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(String.valueOf(this.nextFragmentId++));
        }

        private SubPlan buildFragment(PlanNode root, FragmentProperties properties, PlanFragmentId fragmentId) {
            Set<Symbol> dependencies = SymbolExtractor.extract(root);
            PlanFragment fragment = new PlanFragment(fragmentId, root, Maps.filterKeys(this.types, (Predicate)Predicates.in(dependencies)), properties.getPartitioningHandle(), properties.getDistributeBy(), properties.getPartitionFunction());
            return new SubPlan(fragment, properties.getChildren());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitMetadataDelete(MetadataDeleteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSourceDistribution(node.getId());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PartitionFunctionBinding partitionFunction = exchange.getPartitionFunction();
            ImmutableList.Builder builder = ImmutableList.builder();
            if (exchange.getType() == ExchangeNode.Type.GATHER) {
                context.get().setSingleNodeDistribution();
                for (int i = 0; i < exchange.getSources().size(); ++i) {
                    FragmentProperties childProperties = new FragmentProperties(partitionFunction.translateOutputLayout(exchange.getInputs().get(i)));
                    builder.add((Object)this.buildSubPlan(exchange.getSources().get(i), childProperties, context));
                }
            } else if (exchange.getType() == ExchangeNode.Type.REPARTITION) {
                context.get().setDistribution(partitionFunction.getPartitioningHandle());
                FragmentProperties childProperties = new FragmentProperties(partitionFunction.translateOutputLayout((List)Iterables.getOnlyElement(exchange.getInputs())));
                builder.add((Object)this.buildSubPlan((PlanNode)Iterables.getOnlyElement(exchange.getSources()), childProperties, context));
            } else if (exchange.getType() == ExchangeNode.Type.REPLICATE) {
                FragmentProperties childProperties = new FragmentProperties(partitionFunction.translateOutputLayout((List)Iterables.getOnlyElement(exchange.getInputs())));
                builder.add((Object)this.buildSubPlan((PlanNode)Iterables.getOnlyElement(exchange.getSources()), childProperties, context));
            }
            ImmutableList children = builder.build();
            context.get().addChildren((List<SubPlan>)children);
            List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableCollectors.toImmutableList());
            return new RemoteSourceNode(exchange.getId(), childrenIds, exchange.getOutputSymbols());
        }

        private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PlanFragmentId planFragmentId = this.nextFragmentId();
            PlanNode child = context.rewrite(node, properties);
            return this.buildFragment(child, properties, planFragmentId);
        }
    }
}

