/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.FunctionInvoker;
import com.facebook.presto.sql.planner.DomainUtils;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.GraphvizPrinter;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlanPrinter {
    private final StringBuilder output = new StringBuilder();
    private final Metadata metadata;
    private final Optional<Map<PlanNodeId, PlanNodeStats>> stats;

    private PlanPrinter(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session sesion) {
        this(plan, types, metadata, sesion, 0);
    }

    private PlanPrinter(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session, int indent) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
        this.stats = Optional.empty();
        Visitor visitor = new Visitor(types, session);
        plan.accept(visitor, indent);
    }

    private PlanPrinter(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session, Map<PlanNodeId, PlanNodeStats> stats, int indent) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
        this.stats = Optional.of(stats);
        Visitor visitor = new Visitor(types, session);
        plan.accept(visitor, indent);
    }

    public String toString() {
        return this.output.toString();
    }

    public static String textLogicalPlan(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session) {
        return new PlanPrinter(plan, types, metadata, session).toString();
    }

    public static String textLogicalPlan(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session, int indent) {
        return new PlanPrinter(plan, types, metadata, session, indent).toString();
    }

    public static String textLogicalPlan(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session, Map<PlanNodeId, PlanNodeStats> stats, int indent) {
        return new PlanPrinter(plan, types, metadata, session, stats, indent).toString();
    }

    public static String textDistributedPlan(List<StageInfo> stages, Metadata metadata, Session session) {
        StringBuilder builder = new StringBuilder();
        List allStages = (List)stages.stream().flatMap(stage -> StageInfo.getAllStages(stage).stream()).collect(ImmutableCollectors.toImmutableList());
        for (StageInfo stageInfo : allStages) {
            HashMap<PlanNodeId, PlanNodeStats> aggregatedStats = new HashMap<PlanNodeId, PlanNodeStats>();
            List planNodeStats = stageInfo.getTasks().stream().map(TaskInfo::getStats).flatMap(taskStats -> PlanPrinter.getPlanNodeStats(taskStats).stream()).collect(Collectors.toList());
            for (PlanNodeStats stats : planNodeStats) {
                aggregatedStats.merge(stats.getPlanNodeId(), stats, PlanNodeStats::merge);
            }
            builder.append(PlanPrinter.formatFragment(metadata, session, stageInfo.getPlan(), Optional.of(stageInfo.getStageStats()), Optional.of(aggregatedStats)));
        }
        return builder.toString();
    }

    private static List<PlanNodeStats> getPlanNodeStats(TaskStats taskStats) {
        HashMap outputPositions = new HashMap();
        HashMap outputBytes = new HashMap();
        HashMap<PlanNodeId, Long> wallMillis = new HashMap<PlanNodeId, Long>();
        for (PipelineStats pipelineStats : taskStats.getPipelines()) {
            HashMap<PlanNodeId, Long> pipelineOutputPositions = new HashMap<PlanNodeId, Long>();
            HashMap<PlanNodeId, Long> pipelineOutputBytes = new HashMap<PlanNodeId, Long>();
            List<OperatorStats> operatorSummaries = pipelineStats.getOperatorSummaries();
            for (int i = 0; i < operatorSummaries.size(); ++i) {
                OperatorStats operatorStats = operatorSummaries.get(i);
                PlanNodeId planNodeId = operatorStats.getPlanNodeId();
                long wall = operatorStats.getAddInputWall().toMillis() + operatorStats.getGetOutputWall().toMillis() + operatorStats.getFinishWall().toMillis();
                wallMillis.merge(planNodeId, wall, Long::sum);
                if (i == operatorSummaries.size() - 1 && !pipelineStats.isOutputPipeline()) {
                    pipelineOutputBytes.remove(planNodeId);
                    pipelineOutputPositions.remove(planNodeId);
                    continue;
                }
                pipelineOutputPositions.put(planNodeId, operatorStats.getOutputPositions());
                pipelineOutputBytes.put(planNodeId, operatorStats.getOutputDataSize().toBytes());
            }
            for (Map.Entry entry : pipelineOutputPositions.entrySet()) {
                outputBytes.merge(entry.getKey(), (Long)pipelineOutputBytes.get(entry.getKey()), Long::sum);
                outputPositions.merge(entry.getKey(), (Long)entry.getValue(), Long::sum);
            }
        }
        ArrayList<PlanNodeStats> stats = new ArrayList<PlanNodeStats>();
        for (Map.Entry entry : wallMillis.entrySet()) {
            if (outputPositions.containsKey(entry.getKey())) {
                stats.add(new PlanNodeStats((PlanNodeId)entry.getKey(), new Duration((double)((Long)entry.getValue()).longValue(), TimeUnit.MILLISECONDS), (Long)outputPositions.get(entry.getKey()), DataSize.succinctDataSize((double)((Long)outputBytes.get(entry.getKey())).longValue(), (DataSize.Unit)DataSize.Unit.BYTE)));
                continue;
            }
            stats.add(new PlanNodeStats((PlanNodeId)entry.getKey(), new Duration((double)((Long)entry.getValue()).longValue(), TimeUnit.MILLISECONDS)));
        }
        return stats;
    }

    public static String textDistributedPlan(SubPlan plan, Metadata metadata, Session session) {
        StringBuilder builder = new StringBuilder();
        for (PlanFragment fragment : plan.getAllFragments()) {
            builder.append(PlanPrinter.formatFragment(metadata, session, fragment, Optional.empty(), Optional.empty()));
        }
        return builder.toString();
    }

    private static String formatFragment(Metadata metadata, Session session, PlanFragment fragment, Optional<StageStats> stageStats, Optional<Map<PlanNodeId, PlanNodeStats>> planNodeStats) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Fragment %s [%s]\n", fragment.getId(), fragment.getPartitioning()));
        if (stageStats.isPresent()) {
            builder.append(PlanPrinter.indentString(1)).append(String.format("Cost: CPU %s, Input %d (%s), Output %d (%s)\n", stageStats.get().getTotalCpuTime(), stageStats.get().getProcessedInputPositions(), stageStats.get().getProcessedInputDataSize(), stageStats.get().getOutputPositions(), stageStats.get().getOutputDataSize()));
        }
        PartitionFunctionBinding partitionFunction = fragment.getPartitionFunction();
        builder.append(PlanPrinter.indentString(1)).append(String.format("Output layout: [%s]\n", Joiner.on((String)", ").join(partitionFunction.getOutputLayout())));
        boolean replicateNulls = partitionFunction.isReplicateNulls();
        List arguments = (List)partitionFunction.getPartitionFunctionArguments().stream().map(argument -> {
            if (argument.isConstant()) {
                NullableValue constant = argument.getConstant();
                String printableValue = PlanPrinter.castToVarchar(constant.getType(), constant.getValue(), metadata, session);
                return constant.getType().getDisplayName() + "(" + printableValue + ")";
            }
            return argument.getColumn().toString();
        }).collect(ImmutableCollectors.toImmutableList());
        builder.append(PlanPrinter.indentString(1));
        if (replicateNulls) {
            builder.append(String.format("Output partitioning: %s (replicate nulls) [%s]\n", partitionFunction.getPartitioningHandle(), Joiner.on((String)", ").join((Iterable)arguments)));
        } else {
            builder.append(String.format("Output partitioning: %s [%s]\n", partitionFunction.getPartitioningHandle(), Joiner.on((String)", ").join((Iterable)arguments)));
        }
        if (stageStats.isPresent()) {
            builder.append(PlanPrinter.textLogicalPlan(fragment.getRoot(), fragment.getSymbols(), metadata, session, planNodeStats.get(), 1)).append("\n");
        } else {
            builder.append(PlanPrinter.textLogicalPlan(fragment.getRoot(), fragment.getSymbols(), metadata, session, 1)).append("\n");
        }
        return builder.toString();
    }

    public static String graphvizLogicalPlan(PlanNode plan, Map<Symbol, Type> types) {
        PlanFragment fragment = new PlanFragment(new PlanFragmentId("graphviz_plan"), plan, types, SystemPartitioningHandle.SINGLE_DISTRIBUTION, plan.getId(), new PartitionFunctionBinding(SystemPartitioningHandle.SINGLE_DISTRIBUTION, plan.getOutputSymbols(), (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of()));
        return GraphvizPrinter.printLogical((List<PlanFragment>)ImmutableList.of((Object)fragment));
    }

    public static String graphvizDistributedPlan(SubPlan plan) {
        return GraphvizPrinter.printDistributed(plan);
    }

    private void print(int indent, String format, Object ... args) {
        String value = args.length == 0 ? format : String.format(format, args);
        this.output.append(PlanPrinter.indentString(indent)).append(value).append('\n');
    }

    private void printStats(int indent, PlanNodeId planNodeId) {
        if (!this.stats.isPresent()) {
            return;
        }
        long totalMillis = this.stats.get().values().stream().mapToLong(node -> node.getWallTime().toMillis()).sum();
        PlanNodeStats stats = this.stats.get().get(planNodeId);
        if (stats == null) {
            this.output.append(PlanPrinter.indentString(indent)).append("Cost: unknown, Output: unknown \n");
            return;
        }
        double fraction = (double)stats.getWallTime().toMillis() / (double)totalMillis;
        String fractionString = Double.isFinite(fraction) ? String.format("%.2f%%", 100.0 * fraction) : "unknown";
        String outputString = stats.getOutputPositions().isPresent() && stats.getOutputDataSize().isPresent() ? String.format("%s rows (%s)", stats.getOutputPositions().get(), stats.getOutputDataSize().get()) : "unknown";
        this.output.append(PlanPrinter.indentString(indent)).append(String.format("Cost: %s, Output: %s\n", fractionString, outputString));
    }

    private static String indentString(int indent) {
        return Strings.repeat((String)"    ", (int)indent);
    }

    private static String castToVarchar(Type type, Object value, Metadata metadata, Session session) {
        if (value == null) {
            return "NULL";
        }
        Signature coercion = metadata.getFunctionRegistry().getCoercion(type, (Type)VarcharType.VARCHAR);
        try {
            Slice coerced = (Slice)new FunctionInvoker(metadata.getFunctionRegistry()).invoke(coercion, session.toConnectorSession(), value);
            return coerced.toStringUtf8();
        }
        catch (OperatorNotFoundException e) {
            return "<UNREPRESENTABLE VALUE>";
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    private static class PlanNodeStats {
        private final PlanNodeId planNodeId;
        private final Duration wallTime;
        private final Optional<Long> outputPositions;
        private final Optional<DataSize> outputDataSize;

        public PlanNodeStats(PlanNodeId planNodeId, Duration wallTime) {
            this(planNodeId, wallTime, Optional.empty(), Optional.empty());
        }

        public PlanNodeStats(PlanNodeId planNodeId, Duration wallTime, long outputPositions, DataSize outputDataSize) {
            this(planNodeId, wallTime, Optional.of(outputPositions), Optional.of(outputDataSize));
        }

        private PlanNodeStats(PlanNodeId planNodeId, Duration wallTime, Optional<Long> outputPositions, Optional<DataSize> outputDataSize) {
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.wallTime = Objects.requireNonNull(wallTime, "wallTime is null");
            this.outputPositions = outputPositions;
            this.outputDataSize = outputDataSize;
        }

        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        public Duration getWallTime() {
            return this.wallTime;
        }

        public Optional<Long> getOutputPositions() {
            return this.outputPositions;
        }

        public Optional<DataSize> getOutputDataSize() {
            return this.outputDataSize;
        }

        public static PlanNodeStats merge(PlanNodeStats planNodeStats1, PlanNodeStats planNodeStats2) {
            Preconditions.checkArgument((boolean)planNodeStats1.getPlanNodeId().equals(planNodeStats2.getPlanNodeId()), (String)"planNodeIds do not match. %s != %s", (Object[])new Object[]{planNodeStats1.getPlanNodeId(), planNodeStats2.getPlanNodeId()});
            Optional<Long> outputPositions = planNodeStats1.getOutputPositions().isPresent() && planNodeStats2.getOutputPositions().isPresent() ? Optional.of(planNodeStats1.getOutputPositions().get() + planNodeStats2.getOutputPositions().get()) : (planNodeStats1.getOutputPositions().isPresent() ? planNodeStats1.getOutputPositions() : planNodeStats2.getOutputPositions());
            Optional<DataSize> outputDataSize = planNodeStats1.getOutputDataSize().isPresent() && planNodeStats2.getOutputDataSize().isPresent() ? Optional.of(DataSize.succinctDataSize((double)(planNodeStats1.getOutputDataSize().get().toBytes() + planNodeStats2.getOutputDataSize().get().toBytes()), (DataSize.Unit)DataSize.Unit.BYTE)) : (planNodeStats1.getOutputDataSize().isPresent() ? planNodeStats1.getOutputDataSize() : planNodeStats2.getOutputDataSize());
            return new PlanNodeStats(planNodeStats1.getPlanNodeId(), new Duration((double)(planNodeStats1.getWallTime().toMillis() + planNodeStats2.getWallTime().toMillis()), TimeUnit.MILLISECONDS), outputPositions, outputDataSize);
        }
    }

    private class Visitor
    extends PlanVisitor<Integer, Void> {
        private final Map<Symbol, Type> types;
        private final Session session;

        public Visitor(Map<Symbol, Type> types, Session session) {
            this.types = types;
            this.session = session;
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- ExplainAnalyze => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitJoin(JoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(clause.getLeft().toQualifiedName()), (Expression)new QualifiedNameReference(clause.getRight().toQualifiedName())));
            }
            PlanPrinter.this.print(indent, "- %s[%s] => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getLeft().accept(this, indent + 1);
            node.getRight().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- SemiJoin[%s = %s] => [%s]", new Object[]{node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getSource().accept(this, indent + 1);
            node.getFilteringSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- IndexSource[%s, lookup = %s] => [%s]", new Object[]{node.getIndexHandle(), node.getLookupSymbols(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                if (!node.getOutputSymbols().contains(entry.getKey())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(clause.getProbe().toQualifiedName()), (Expression)new QualifiedNameReference(clause.getIndex().toQualifiedName())));
            }
            PlanPrinter.this.print(indent, "- %sIndexJoin[%s] => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getProbeSource().accept(this, indent + 1);
            node.getIndexSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Limit[%s] => [%s]", new Object[]{node.getCount(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- DistinctLimit[%s] => [%s]", new Object[]{node.getLimit(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Integer indent) {
            String type = "";
            if (node.getStep() != AggregationNode.Step.SINGLE) {
                type = String.format("(%s)", node.getStep().toString());
            }
            String key = "";
            if (!node.getGroupBy().isEmpty()) {
                key = node.getGroupBy().toString();
            }
            String sampleWeight = "";
            if (node.getSampleWeight().isPresent()) {
                sampleWeight = String.format("[sampleWeight = %s]", node.getSampleWeight().get());
            }
            PlanPrinter.this.print(indent, "- Aggregate%s%s%s => [%s]", new Object[]{type, key, sampleWeight, this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                if (node.getMasks().containsKey(entry.getKey())) {
                    PlanPrinter.this.print(indent + 2, "%s := %s (mask = %s)", new Object[]{entry.getKey(), entry.getValue(), node.getMasks().get(entry.getKey())});
                    continue;
                }
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- GroupId%s => [%s]", new Object[]{node.getGroupingSets(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- MarkDistinct[distinct=%s marker=%s] => [%s]", new Object[]{this.formatOutputs(node.getDistinctSymbols()), node.getMarkerSymbol(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitWindow(WindowNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            List orderBy = Lists.transform(node.getOrderBy(), input -> input + " " + node.getOrderings().get(input));
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                List prePartitioned = (List)node.getPartitionBy().stream().filter(node.getPrePartitionedInputs()::contains).collect(ImmutableCollectors.toImmutableList());
                List notPrePartitioned = (List)node.getPartitionBy().stream().filter(column -> !node.getPrePartitionedInputs().contains(column)).collect(ImmutableCollectors.toImmutableList());
                StringBuilder builder = new StringBuilder();
                if (!prePartitioned.isEmpty()) {
                    builder.append("<").append(Joiner.on((String)", ").join((Iterable)prePartitioned)).append(">");
                    if (!notPrePartitioned.isEmpty()) {
                        builder.append(", ");
                    }
                }
                if (!notPrePartitioned.isEmpty()) {
                    builder.append(Joiner.on((String)", ").join((Iterable)notPrePartitioned));
                }
                args.add(String.format("partition by (%s)", builder));
            }
            if (!orderBy.isEmpty()) {
                args.add(String.format("order by (%s)", Stream.concat(node.getOrderBy().stream().limit(node.getPreSortedOrderPrefix()).map(symbol -> "<" + symbol + ">"), node.getOrderBy().stream().skip(node.getPreSortedOrderPrefix()).map(Symbol::toString)).collect(Collectors.joining(", "))));
            }
            PlanPrinter.this.print(indent, "- Window[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(args), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s(%s)", new Object[]{entry.getKey(), entry.getValue().getName(), Joiner.on((String)", ").join((Iterable)entry.getValue().getArguments())});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            List orderBy = Lists.transform(node.getOrderBy(), input -> input + " " + node.getOrderings().get(input));
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            args.add(String.format("order by (%s)", Joiner.on((String)", ").join((Iterable)orderBy)));
            PlanPrinter.this.print(indent, "- TopNRowNumber[%s limit %s] => [%s]", new Object[]{Joiner.on((String)", ").join(args), node.getMaxRowCountPerPartition(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{node.getRowNumberSymbol(), "row_number()"});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            }
            if (node.getMaxRowCountPerPartition().isPresent()) {
                args.add(String.format("limit = %s", node.getMaxRowCountPerPartition().get()));
            }
            PlanPrinter.this.print(indent, "- RowNumber[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(args), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{node.getRowNumberSymbol(), "row_number()"});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Integer indent) {
            TableHandle table = node.getTable();
            PlanPrinter.this.print(indent, "- TableScan[%s, originalConstraint = %s] => [%s]", new Object[]{table, node.getOriginalConstraint(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            TupleDomain predicate = node.getLayout().map(layoutHandle -> PlanPrinter.this.metadata.getLayout(this.session, (TableLayoutHandle)layoutHandle)).map(TableLayout::getPredicate).orElse(TupleDomain.all());
            if (node.getLayout().isPresent()) {
                ConnectorTableLayoutHandle layout = node.getLayout().get().getConnectorHandle();
                if (!table.getConnectorHandle().toString().equals(layout.toString())) {
                    PlanPrinter.this.print(indent + 2, "LAYOUT: %s", new Object[]{layout});
                }
            }
            if (predicate.isNone()) {
                PlanPrinter.this.print(indent + 2, ":: NONE", new Object[0]);
            } else {
                for (Map.Entry entry2 : node.getAssignments().entrySet()) {
                    ColumnHandle column = (ColumnHandle)entry2.getValue();
                    PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry2.getKey(), column});
                    this.printConstraint(indent + 3, column, (TupleDomain<ColumnHandle>)predicate);
                }
                if (!predicate.isAll()) {
                    ImmutableSet outputs = ImmutableSet.copyOf(node.getAssignments().values());
                    ((Map)predicate.getDomains().get()).entrySet().stream().filter(arg_0 -> Visitor.lambda$visitTableScan$5((Set)outputs, arg_0)).forEach(entry -> {
                        ColumnHandle column = (ColumnHandle)entry.getKey();
                        PlanPrinter.this.print(indent + 2, "%s", new Object[]{column});
                        this.printConstraint(indent + 3, column, (TupleDomain<ColumnHandle>)predicate);
                    });
                }
            }
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Values => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (List<Expression> row : node.getRows()) {
                PlanPrinter.this.print(indent + 2, "(" + Joiner.on((String)", ").join(row) + ")", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Filter[%s] => [%s]", new Object[]{node.getPredicate(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitProject(ProjectNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Project => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                if (entry.getValue() instanceof QualifiedNameReference && ((QualifiedNameReference)entry.getValue()).getName().equals((Object)entry.getKey().toQualifiedName())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitUnnest(UnnestNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Unnest [replicate=%s, unnest=%s] => [%s]", new Object[]{this.formatOutputs(node.getReplicateSymbols()), this.formatOutputs(node.getUnnestSymbols().keySet()), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitOutput(OutputNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Output[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(node.getColumnNames()), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                Symbol symbol;
                String name = node.getColumnNames().get(i);
                if (name.equals((symbol = node.getOutputSymbols().get(i)).toString())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopN(TopNNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderBy(), input -> input + " " + node.getOrderings().get(input));
            PlanPrinter.this.print(indent, "- TopN[%s by (%s)] => [%s]", new Object[]{node.getCount(), Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitSort(SortNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderBy(), input -> input + " " + node.getOrderings().get(input));
            PlanPrinter.this.print(indent, "- Sort[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- RemoteSource[%s] => [%s]", new Object[]{Joiner.on((char)',').join(node.getSourceFragmentIds()), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Union => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableWriter => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getColumns().get(i);
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableCommit[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitSample(SampleNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Sample[%s: %s] => [%s]", new Object[]{node.getSampleType(), node.getSampleRatio(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitExchange(ExchangeNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Exchange[%s] => %s", new Object[]{node.getType(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitDelete(DeleteNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Delete[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitMetadataDelete(MetadataDeleteNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- MetadataDelete[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Scalar => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        protected Void visitPlan(PlanNode node, Integer context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node, int indent) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, indent);
            }
            return null;
        }

        private String formatOutputs(Iterable<Symbol> symbols) {
            return Joiner.on((String)", ").join(Iterables.transform(symbols, input -> input + ":" + this.types.get(input).getDisplayName()));
        }

        private void printConstraint(int indent, ColumnHandle column, TupleDomain<ColumnHandle> constraint) {
            Preconditions.checkArgument((!constraint.isNone() ? 1 : 0) != 0);
            Map domains = (Map)constraint.getDomains().get();
            if (!constraint.isAll() && domains.containsKey(column)) {
                PlanPrinter.this.print(indent, ":: %s", new Object[]{this.formatDomain(DomainUtils.simplifyDomain((Domain)domains.get(column)))});
            }
        }

        private String formatDomain(Domain domain) {
            ImmutableList.Builder parts = ImmutableList.builder();
            if (domain.isNullAllowed()) {
                parts.add((Object)"NULL");
            }
            Type type = domain.getType();
            domain.getValues().getValuesProcessor().consume(ranges -> {
                for (Range range : ranges.getOrderedRanges()) {
                    StringBuilder builder = new StringBuilder();
                    if (range.isSingleValue()) {
                        String value = PlanPrinter.castToVarchar(type, range.getSingleValue(), PlanPrinter.this.metadata, this.session);
                        builder.append('[').append(value).append(']');
                    } else {
                        builder.append(range.getLow().getBound() == Marker.Bound.EXACTLY ? (char)'[' : (char)'(');
                        if (range.getLow().isLowerUnbounded()) {
                            builder.append("<min>");
                        } else {
                            builder.append(PlanPrinter.castToVarchar(type, range.getLow().getValue(), PlanPrinter.this.metadata, this.session));
                        }
                        builder.append(", ");
                        if (range.getHigh().isUpperUnbounded()) {
                            builder.append("<max>");
                        } else {
                            builder.append(PlanPrinter.castToVarchar(type, range.getHigh().getValue(), PlanPrinter.this.metadata, this.session));
                        }
                        builder.append(range.getHigh().getBound() == Marker.Bound.EXACTLY ? (char)']' : (char)')');
                    }
                    parts.add((Object)builder.toString());
                }
            }, discreteValues -> discreteValues.getValues().stream().map(value -> PlanPrinter.castToVarchar(type, value, PlanPrinter.this.metadata, this.session)).sorted().forEach(arg_0 -> ((ImmutableList.Builder)parts).add(arg_0)), allOrNone -> {
                if (allOrNone.isAll()) {
                    parts.add((Object)"ALL VALUES");
                }
            });
            return "[" + Joiner.on((String)", ").join((Iterable)parts.build()) + "]";
        }

        private static /* synthetic */ boolean lambda$visitTableScan$5(Set outputs, Map.Entry entry) {
            return !outputs.contains(entry.getKey());
        }
    }
}

