/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

class ActualProperties {
    private final Global global;
    private final List<LocalProperty<Symbol>> localProperties;
    private final Map<Symbol, NullableValue> constants;

    private ActualProperties(Global global, List<? extends LocalProperty<Symbol>> localProperties, Map<Symbol, NullableValue> constants) {
        Objects.requireNonNull(global, "globalProperties is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        Objects.requireNonNull(constants, "constants is null");
        this.global = global;
        Set localConstants = LocalProperties.extractLeadingConstants(localProperties);
        localProperties = LocalProperties.stripLeadingConstants(localProperties);
        ImmutableSet updatedLocalConstants = ImmutableSet.builder().addAll(localConstants).addAll(constants.keySet()).build();
        List updatedLocalProperties = LocalProperties.normalizeAndPrune(ImmutableList.builder().addAll(Iterables.transform((Iterable)updatedLocalConstants, ConstantProperty::new)).addAll(localProperties).build());
        this.localProperties = ImmutableList.copyOf(updatedLocalProperties);
        this.constants = ImmutableMap.copyOf(constants);
    }

    public boolean isCoordinatorOnly() {
        return this.global.isCoordinatorOnly();
    }

    public boolean isSingleNode() {
        return this.global.isSingleNode();
    }

    public boolean isStreamPartitionedOn(Collection<Symbol> columns) {
        return this.global.isStreamPartitionedOn(columns, this.constants.keySet());
    }

    public boolean isNodePartitionedOn(Collection<Symbol> columns) {
        return this.global.isNodePartitionedOn(columns, this.constants.keySet());
    }

    public boolean isNodePartitionedOn(PartitioningHandle partitioning, List<Symbol> columns) {
        return this.global.isNodePartitionedOn(partitioning, columns);
    }

    public boolean isNodePartitionedWith(ActualProperties other, Function<Symbol, Set<Symbol>> symbolMappings) {
        return this.global.isNodePartitionedWith(other.global, symbolMappings, this.constants::get, other.constants::get);
    }

    public boolean isEffectivelySingleStream() {
        return this.global.isEffectivelySingleStream(this.constants.keySet());
    }

    public boolean isStreamRepartitionEffective(Collection<Symbol> keys) {
        return this.global.isStreamRepartitionEffective(keys, this.constants.keySet());
    }

    public ActualProperties translate(Function<Symbol, Optional<Symbol>> translator) {
        HashMap<Symbol, NullableValue> translatedConstants = new HashMap<Symbol, NullableValue>();
        for (Map.Entry<Symbol, NullableValue> entry : this.constants.entrySet()) {
            Optional<Symbol> translatedKey = translator.apply(entry.getKey());
            if (!translatedKey.isPresent()) continue;
            translatedConstants.put(translatedKey.get(), entry.getValue());
        }
        return ActualProperties.builder().global(this.global.translate(translator, symbol -> Optional.ofNullable(this.constants.get(symbol)))).local(LocalProperties.translate(this.localProperties, translator)).constants(translatedConstants).build();
    }

    public Optional<PartitioningHandle> getNodePartitioningHandle() {
        return this.global.getNodePartitioningHandle();
    }

    public Optional<List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>> getNodePartitioningColumns() {
        return this.global.getNodePartitioningColumns();
    }

    public Map<Symbol, NullableValue> getConstants() {
        return this.constants;
    }

    public List<LocalProperty<Symbol>> getLocalProperties() {
        return this.localProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(ActualProperties properties) {
        return new Builder(properties.global, properties.localProperties, properties.constants);
    }

    public int hashCode() {
        return Objects.hash(this.global, this.localProperties, this.constants.keySet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActualProperties other = (ActualProperties)obj;
        return Objects.equals(this.global, other.global) && Objects.equals(this.localProperties, other.localProperties) && Objects.equals(this.constants.keySet(), other.constants.keySet());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("globalProperties", (Object)this.global).add("localProperties", this.localProperties).add("constants", this.constants).toString();
    }

    @Immutable
    public static final class Partitioning {
        private final PartitioningHandle partitioningHandle;
        private final List<PartitionFunctionBinding.PartitionFunctionArgumentBinding> partitioningArguments;

        public Partitioning(PartitioningHandle partitioningHandle, List<PartitionFunctionBinding.PartitionFunctionArgumentBinding> partitioningArguments) {
            this.partitioningHandle = Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
            this.partitioningArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningArguments, "partitioningArguments is null"));
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle;
        }

        public List<PartitionFunctionBinding.PartitionFunctionArgumentBinding> getPartitioningArguments() {
            return this.partitioningArguments;
        }

        public boolean isPartitionedOn(PartitioningHandle partitioning, List<Symbol> columns) {
            if (!this.partitioningHandle.equals(partitioning)) {
                return false;
            }
            if (this.partitioningArguments.size() != columns.size()) {
                return false;
            }
            for (int i = 0; i < this.partitioningArguments.size(); ++i) {
                PartitionFunctionBinding.PartitionFunctionArgumentBinding argument = this.partitioningArguments.get(i);
                if (!argument.isVariable() || argument.getColumn().equals(columns.get(i))) continue;
                return false;
            }
            return true;
        }

        public boolean isPartitionedWith(Partitioning right, Function<Symbol, Set<Symbol>> leftToRightMappings, Function<Symbol, NullableValue> leftConstantMapping, Function<Symbol, NullableValue> rightConstantMapping) {
            if (!this.partitioningHandle.equals(right.partitioningHandle)) {
                return false;
            }
            if (this.partitioningArguments.size() != right.partitioningArguments.size()) {
                return false;
            }
            for (int i = 0; i < this.partitioningArguments.size(); ++i) {
                PartitionFunctionBinding.PartitionFunctionArgumentBinding rightArgument;
                PartitionFunctionBinding.PartitionFunctionArgumentBinding leftArgument = this.partitioningArguments.get(i);
                if (Partitioning.isPartitionedWith(leftArgument, leftConstantMapping, rightArgument = right.partitioningArguments.get(i), rightConstantMapping, leftToRightMappings)) continue;
                return false;
            }
            return true;
        }

        private static boolean isPartitionedWith(PartitionFunctionBinding.PartitionFunctionArgumentBinding leftArgument, Function<Symbol, NullableValue> leftConstantMapping, PartitionFunctionBinding.PartitionFunctionArgumentBinding rightArgument, Function<Symbol, NullableValue> rightConstantMapping, Function<Symbol, Set<Symbol>> leftToRightMappings) {
            if (leftArgument.isVariable()) {
                if (rightArgument.isVariable()) {
                    Set<Symbol> mappedColumns = leftToRightMappings.apply(leftArgument.getColumn());
                    return mappedColumns.contains(rightArgument.getColumn());
                }
                NullableValue leftConstant = leftConstantMapping.apply(leftArgument.getColumn());
                return leftConstant != null && leftConstant.equals((Object)rightArgument.getConstant());
            }
            if (rightArgument.isConstant()) {
                return leftArgument.getConstant().equals((Object)rightArgument.getConstant());
            }
            NullableValue rightConstant = rightConstantMapping.apply(rightArgument.getColumn());
            return leftArgument.getConstant().equals((Object)rightConstant);
        }

        public boolean isPartitionedOn(Collection<Symbol> columns, Set<Symbol> knownConstants) {
            return this.partitioningArguments.stream().filter(PartitionFunctionBinding.PartitionFunctionArgumentBinding::isVariable).map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::getColumn).filter(symbol -> !knownConstants.contains(symbol)).allMatch(columns::contains);
        }

        public boolean isEffectivelySinglePartition(Set<Symbol> knownConstants) {
            return this.isPartitionedOn((Collection<Symbol>)ImmutableSet.of(), knownConstants);
        }

        public boolean isRepartitionEffective(Collection<Symbol> keys, Set<Symbol> knownConstants) {
            Set keysWithoutConstants = (Set)keys.stream().filter(symbol -> !knownConstants.contains(symbol)).collect(ImmutableCollectors.toImmutableSet());
            Set nonConstantArgs = (Set)this.partitioningArguments.stream().filter(PartitionFunctionBinding.PartitionFunctionArgumentBinding::isVariable).map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::getColumn).filter(symbol -> !knownConstants.contains(symbol)).collect(ImmutableCollectors.toImmutableSet());
            return !nonConstantArgs.equals(keysWithoutConstants);
        }

        public Optional<Partitioning> translate(Function<Symbol, Optional<Symbol>> translator, Function<Symbol, Optional<NullableValue>> constants) {
            ImmutableList.Builder newArguments = ImmutableList.builder();
            for (PartitionFunctionBinding.PartitionFunctionArgumentBinding argument : this.partitioningArguments) {
                Optional<PartitionFunctionBinding.PartitionFunctionArgumentBinding> newArgument = Partitioning.translate(argument, translator, constants);
                if (!newArgument.isPresent()) {
                    return Optional.empty();
                }
                newArguments.add((Object)newArgument.get());
            }
            return Optional.of(new Partitioning(this.partitioningHandle, (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)newArguments.build()));
        }

        private static Optional<PartitionFunctionBinding.PartitionFunctionArgumentBinding> translate(PartitionFunctionBinding.PartitionFunctionArgumentBinding argument, Function<Symbol, Optional<Symbol>> translator, Function<Symbol, Optional<NullableValue>> constants) {
            if (argument.isConstant()) {
                return Optional.of(argument);
            }
            Optional<Symbol> newSymbol = translator.apply(argument.getColumn());
            if (newSymbol.isPresent()) {
                return Optional.of(new PartitionFunctionBinding.PartitionFunctionArgumentBinding(newSymbol.get()));
            }
            Optional<NullableValue> constant = constants.apply(argument.getColumn());
            if (constant.isPresent()) {
                return Optional.of(new PartitionFunctionBinding.PartitionFunctionArgumentBinding(constant.get()));
            }
            return Optional.empty();
        }

        public int hashCode() {
            return Objects.hash(this.partitioningHandle, this.partitioningArguments);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Partitioning other = (Partitioning)obj;
            return Objects.equals(this.partitioningHandle, other.partitioningHandle) && Objects.equals(this.partitioningArguments, other.partitioningArguments);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitioningHandle", (Object)this.partitioningHandle).add("partitioningColumns", this.partitioningArguments).toString();
        }
    }

    @Immutable
    public static final class Global {
        private final Optional<Partitioning> nodePartitioning;
        private final Optional<Partitioning> streamPartitioning;

        private Global(Optional<Partitioning> nodePartitioning, Optional<Partitioning> streamPartitioning) {
            this.nodePartitioning = Objects.requireNonNull(nodePartitioning, "nodePartitioning is null");
            this.streamPartitioning = Objects.requireNonNull(streamPartitioning, "streamPartitioning is null");
        }

        public static Global coordinatorSingleStreamPartition() {
            return Global.partitionedOn(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of(), Optional.of(ImmutableList.of()));
        }

        public static Global singleStreamPartition() {
            return Global.partitionedOn(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of(), Optional.of(ImmutableList.of()));
        }

        public static Global arbitraryPartition() {
            return new Global(Optional.empty(), Optional.empty());
        }

        public static Global partitionedOn(PartitioningHandle nodePartitioningHandle, List<PartitionFunctionBinding.PartitionFunctionArgumentBinding> nodePartitioning, Optional<List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>> streamPartitioning) {
            return new Global(Optional.of(new Partitioning(nodePartitioningHandle, nodePartitioning)), streamPartitioning.map(columns -> new Partitioning(SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)columns)));
        }

        public static Global streamPartitionedOn(List<PartitionFunctionBinding.PartitionFunctionArgumentBinding> streamPartitioning) {
            return new Global(Optional.empty(), Optional.of(new Partitioning(SystemPartitioningHandle.SOURCE_DISTRIBUTION, streamPartitioning)));
        }

        private boolean isSingleNode() {
            if (!this.nodePartitioning.isPresent()) {
                return false;
            }
            return this.nodePartitioning.get().getPartitioningHandle().isSingleNode();
        }

        private boolean isCoordinatorOnly() {
            if (!this.nodePartitioning.isPresent()) {
                return false;
            }
            return this.nodePartitioning.get().getPartitioningHandle().isCoordinatorOnly();
        }

        private boolean isNodePartitionedOn(Collection<Symbol> columns, Set<Symbol> constants) {
            return this.nodePartitioning.isPresent() && this.nodePartitioning.get().isPartitionedOn(columns, constants);
        }

        private boolean isNodePartitionedOn(PartitioningHandle partitioning, List<Symbol> columns) {
            return this.nodePartitioning.isPresent() && this.nodePartitioning.get().isPartitionedOn(partitioning, columns);
        }

        private boolean isNodePartitionedWith(Global other, Function<Symbol, Set<Symbol>> symbolMappings, Function<Symbol, NullableValue> leftConstantMapping, Function<Symbol, NullableValue> rightConstantMapping) {
            return this.nodePartitioning.isPresent() && other.nodePartitioning.isPresent() && this.nodePartitioning.get().isPartitionedWith(other.nodePartitioning.get(), symbolMappings, leftConstantMapping, rightConstantMapping);
        }

        private Optional<PartitioningHandle> getNodePartitioningHandle() {
            return this.nodePartitioning.map(Partitioning::getPartitioningHandle);
        }

        private Optional<List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>> getNodePartitioningColumns() {
            return this.nodePartitioning.map(Partitioning::getPartitioningArguments);
        }

        private boolean isStreamPartitionedOn(Collection<Symbol> columns, Set<Symbol> constants) {
            return this.streamPartitioning.isPresent() && this.streamPartitioning.get().isPartitionedOn(columns, constants);
        }

        private boolean isEffectivelySingleStream(Set<Symbol> constants) {
            return this.streamPartitioning.isPresent() && this.streamPartitioning.get().isEffectivelySinglePartition(constants);
        }

        private boolean isStreamRepartitionEffective(Collection<Symbol> keys, Set<Symbol> constants) {
            return !this.streamPartitioning.isPresent() || this.streamPartitioning.get().isRepartitionEffective(keys, constants);
        }

        private Global translate(Function<Symbol, Optional<Symbol>> translator, Function<Symbol, Optional<NullableValue>> constants) {
            return new Global(this.nodePartitioning.flatMap(partitioning -> partitioning.translate(translator, constants)), this.streamPartitioning.flatMap(partitioning -> partitioning.translate(translator, constants)));
        }

        public int hashCode() {
            return Objects.hash(this.nodePartitioning, this.streamPartitioning);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.nodePartitioning, other.nodePartitioning) && Objects.equals(this.streamPartitioning, other.streamPartitioning);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nodePartitioning", this.nodePartitioning).add("streamPartitioning", this.streamPartitioning).toString();
        }
    }

    public static class Builder {
        private Global global;
        private List<LocalProperty<Symbol>> localProperties;
        private Map<Symbol, NullableValue> constants;

        public Builder(Global global, List<LocalProperty<Symbol>> localProperties, Map<Symbol, NullableValue> constants) {
            this.global = global;
            this.localProperties = localProperties;
            this.constants = constants;
        }

        public Builder() {
            this.global = Global.arbitraryPartition();
            this.localProperties = ImmutableList.of();
            this.constants = ImmutableMap.of();
        }

        public Builder global(Global global) {
            this.global = global;
            return this;
        }

        public Builder global(ActualProperties other) {
            this.global = other.global;
            return this;
        }

        public Builder local(List<? extends LocalProperty<Symbol>> localProperties) {
            this.localProperties = ImmutableList.copyOf(localProperties);
            return this;
        }

        public Builder constants(Map<Symbol, NullableValue> constants) {
            this.constants = ImmutableMap.copyOf(constants);
            return this;
        }

        public ActualProperties build() {
            return new ActualProperties(this.global, this.localProperties, this.constants);
        }
    }
}

