/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.airlift.slice.Slice;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExpressionEquivalence {
    private static final Ordering<RowExpression> ROW_EXPRESSION_ORDERING = Ordering.from((Comparator)new RowExpressionComparator());
    private static final CanonicalizationVisitor CANONICALIZATION_VISITOR = new CanonicalizationVisitor();
    private final Metadata metadata;
    private final SqlParser sqlParser;

    public ExpressionEquivalence(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    public boolean areExpressionsEquivalent(Session session, Expression leftExpression, Expression rightExpression, Map<Symbol, Type> types) {
        HashMap<Symbol, Integer> symbolInput = new HashMap<Symbol, Integer>();
        HashMap<Integer, Type> inputTypes = new HashMap<Integer, Type>();
        int inputId = 0;
        for (Map.Entry<Symbol, Type> entry : types.entrySet()) {
            symbolInput.put(entry.getKey(), inputId);
            inputTypes.put(inputId, entry.getValue());
            ++inputId;
        }
        RowExpression leftRowExpression = this.toRowExpression(session, leftExpression, symbolInput, inputTypes);
        RowExpression rightRowExpression = this.toRowExpression(session, rightExpression, symbolInput, inputTypes);
        RowExpression canonicalizedLeft = leftRowExpression.accept(CANONICALIZATION_VISITOR, null);
        RowExpression canonicalizedRight = rightRowExpression.accept(CANONICALIZATION_VISITOR, null);
        return canonicalizedLeft.equals(canonicalizedRight);
    }

    private RowExpression toRowExpression(Session session, Expression expression, Map<Symbol, Integer> symbolInput, Map<Integer, Type> inputTypes) {
        Expression expressionWithInputReferences = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(symbolInput), (Expression)expression);
        IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, this.metadata, this.sqlParser, inputTypes, expressionWithInputReferences);
        return SqlToRowExpressionTranslator.translate(expressionWithInputReferences, FunctionKind.SCALAR, expressionTypes, this.metadata.getFunctionRegistry(), this.metadata.getTypeManager(), session, false);
    }

    private static <T> List<T> swapPair(List<T> pair) {
        Objects.requireNonNull(pair, "pair is null");
        Preconditions.checkArgument((pair.size() == 2 ? 1 : 0) != 0, (Object)"Expected pair to have two elements");
        return ImmutableList.of(pair.get(1), pair.get(0));
    }

    private static class ListComparator<T>
    implements Comparator<List<T>> {
        private final Comparator<T> elementComparator;

        public ListComparator(Comparator<T> elementComparator) {
            this.elementComparator = Objects.requireNonNull(elementComparator, "elementComparator is null");
        }

        @Override
        public int compare(List<T> left, List<T> right) {
            int compareLength = Integer.min(left.size(), right.size());
            for (int i = 0; i < compareLength; ++i) {
                int result = this.elementComparator.compare(left.get(i), right.get(i));
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(left.size(), right.size());
        }
    }

    private static class RowExpressionComparator
    implements Comparator<RowExpression> {
        private final Comparator<Object> classComparator = Ordering.arbitrary();
        private final ListComparator<RowExpression> argumentComparator = new ListComparator<RowExpression>(this);

        private RowExpressionComparator() {
        }

        @Override
        public int compare(RowExpression left, RowExpression right) {
            int result = this.classComparator.compare(left.getClass(), right.getClass());
            if (result != 0) {
                return result;
            }
            if (left instanceof CallExpression) {
                CallExpression leftCall = (CallExpression)left;
                CallExpression rightCall = (CallExpression)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftCall.getSignature().toString()), (Comparable)((Object)rightCall.getSignature().toString())).compare(leftCall.getArguments(), rightCall.getArguments(), this.argumentComparator).result();
            }
            if (left instanceof ConstantExpression) {
                ConstantExpression leftConstant = (ConstantExpression)left;
                ConstantExpression rightConstant = (ConstantExpression)right;
                result = leftConstant.getType().getTypeSignature().toString().compareTo(right.getType().getTypeSignature().toString());
                if (result != 0) {
                    return result;
                }
                Object leftValue = leftConstant.getValue();
                Object rightValue = rightConstant.getValue();
                Class javaType = leftConstant.getType().getJavaType();
                if (javaType == Boolean.TYPE) {
                    return ((Boolean)leftValue).compareTo((Boolean)rightValue);
                }
                if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE || javaType == Long.TYPE) {
                    return Long.compare(((Number)leftValue).longValue(), ((Number)rightValue).longValue());
                }
                if (javaType == Float.TYPE || javaType == Double.TYPE) {
                    return Double.compare(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue());
                }
                if (javaType == Slice.class) {
                    return ((Slice)leftValue).compareTo((Slice)rightValue);
                }
                return -1;
            }
            if (left instanceof InputReferenceExpression) {
                return Integer.compare(((InputReferenceExpression)left).getField(), ((InputReferenceExpression)right).getField());
            }
            throw new IllegalArgumentException("Unsupported RowExpression type " + left.getClass().getSimpleName());
        }
    }

    private static class CanonicalizationVisitor
    implements RowExpressionVisitor<Void, RowExpression> {
        private CanonicalizationVisitor() {
        }

        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            String callName = (call = new CallExpression(call.getSignature(), call.getType(), (List)call.getArguments().stream().map(expression -> expression.accept(this, context)).collect(ImmutableCollectors.toImmutableList()))).getSignature().getName();
            if (callName.equals("AND") || callName.equals("OR")) {
                List<RowExpression> flattenedArguments = CanonicalizationVisitor.flattenNestedCallArgs(call);
                ImmutableSet distinctArguments = ImmutableSet.copyOf(flattenedArguments);
                if (distinctArguments.size() == 1) {
                    return (RowExpression)Iterables.getOnlyElement((Iterable)distinctArguments);
                }
                List sortedArguments = ROW_EXPRESSION_ORDERING.sortedCopy((Iterable)distinctArguments);
                return new CallExpression(Signature.internalScalarFunction(callName, BooleanType.BOOLEAN.getTypeSignature(), (List)distinctArguments.stream().map(RowExpression::getType).map(Type::getTypeSignature).collect(ImmutableCollectors.toImmutableList())), (Type)BooleanType.BOOLEAN, sortedArguments);
            }
            if (callName.equals(FunctionRegistry.mangleOperatorName(OperatorType.EQUAL)) || callName.equals(FunctionRegistry.mangleOperatorName(OperatorType.NOT_EQUAL)) || callName.equals("IS_DISTINCT_FROM")) {
                return new CallExpression(call.getSignature(), call.getType(), ROW_EXPRESSION_ORDERING.sortedCopy(call.getArguments()));
            }
            if (callName.equals(FunctionRegistry.mangleOperatorName(OperatorType.GREATER_THAN)) || callName.equals(FunctionRegistry.mangleOperatorName(OperatorType.GREATER_THAN_OR_EQUAL))) {
                return new CallExpression(new Signature(callName.equals(FunctionRegistry.mangleOperatorName(OperatorType.GREATER_THAN)) ? FunctionRegistry.mangleOperatorName(OperatorType.LESS_THAN) : FunctionRegistry.mangleOperatorName(OperatorType.LESS_THAN_OR_EQUAL), FunctionKind.SCALAR, call.getSignature().getTypeParameterRequirements(), call.getSignature().getReturnType(), ExpressionEquivalence.swapPair(call.getSignature().getArgumentTypes()), false), call.getType(), ExpressionEquivalence.swapPair(call.getArguments()));
            }
            return call;
        }

        public static List<RowExpression> flattenNestedCallArgs(CallExpression call) {
            String callName = call.getSignature().getName();
            ImmutableList.Builder newArguments = ImmutableList.builder();
            for (RowExpression argument : call.getArguments()) {
                if (argument instanceof CallExpression && callName.equals(((CallExpression)argument).getSignature().getName())) {
                    newArguments.addAll(CanonicalizationVisitor.flattenNestedCallArgs((CallExpression)argument));
                    continue;
                }
                newArguments.add((Object)argument);
            }
            return newArguments.build();
        }

        @Override
        public RowExpression visitConstant(ConstantExpression constant, Void context) {
            return constant;
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression node, Void context) {
            return node;
        }
    }
}

