/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PruneUnreferencedOutputs
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(types), plan, ImmutableSet.of());
    }

    private static class Rewriter
    extends SimplePlanRewriter<Set<Symbol>> {
        private final Map<Symbol, Type> types;

        public Rewriter(Map<Symbol, Type> types) {
            this.types = types;
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            return context.defaultRewrite(node, (Set<Symbol>)ImmutableSet.copyOf(node.getSource().getOutputSymbols()));
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            HashSet expectedOutputSymbols = Sets.newHashSet((Iterable)context.get());
            node.getPartitionFunction().getHashColumn().ifPresent(expectedOutputSymbols::add);
            node.getPartitionFunction().getPartitionFunctionArguments().stream().filter(PartitionFunctionBinding.PartitionFunctionArgumentBinding::isVariable).map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::getColumn).forEach(expectedOutputSymbols::add);
            ArrayList<List<Symbol>> inputsBySource = new ArrayList<List<Symbol>>(node.getInputs().size());
            for (int i = 0; i < node.getInputs().size(); ++i) {
                inputsBySource.add(new ArrayList());
            }
            ArrayList<Symbol> newOutputSymbols = new ArrayList<Symbol>(node.getOutputSymbols().size());
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol outputSymbol = node.getOutputSymbols().get(i);
                if (!expectedOutputSymbols.contains(outputSymbol)) continue;
                newOutputSymbols.add(outputSymbol);
                for (int source = 0; source < node.getInputs().size(); ++source) {
                    ((List)inputsBySource.get(source)).add(node.getInputs().get(source).get(i));
                }
            }
            PartitionFunctionBinding partitionFunctionBinding = new PartitionFunctionBinding(node.getPartitionFunction().getPartitioningHandle(), newOutputSymbols, node.getPartitionFunction().getPartitionFunctionArguments(), node.getPartitionFunction().getHashColumn(), node.getPartitionFunction().isReplicateNulls(), node.getPartitionFunction().getBucketToPartition());
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)inputsBySource.get(i));
                rewrittenSources.add((Object)context.rewrite(node.getSources().get(i), (Set<Symbol>)expectedInputs.build()));
            }
            return new ExchangeNode(node.getId(), node.getType(), partitionFunctionBinding, (List<PlanNode>)rewrittenSources.build(), inputsBySource);
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder leftInputsBuilder = ImmutableSet.builder();
            leftInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), JoinNode.EquiJoinClause::getLeft));
            if (node.getLeftHashSymbol().isPresent()) {
                leftInputsBuilder.add((Object)node.getLeftHashSymbol().get());
            }
            ImmutableSet leftInputs = leftInputsBuilder.build();
            ImmutableSet.Builder rightInputsBuilder = ImmutableSet.builder();
            rightInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight));
            if (node.getRightHashSymbol().isPresent()) {
                rightInputsBuilder.add((Object)node.getRightHashSymbol().get());
            }
            ImmutableSet rightInputs = rightInputsBuilder.build();
            PlanNode left = context.rewrite(node.getLeft(), (Set<Symbol>)leftInputs);
            PlanNode right = context.rewrite(node.getRight(), (Set<Symbol>)rightInputs);
            return new JoinNode(node.getId(), node.getType(), left, right, node.getCriteria(), node.getLeftHashSymbol(), node.getRightHashSymbol());
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder sourceInputsBuilder = ImmutableSet.builder();
            sourceInputsBuilder.addAll((Iterable)context.get()).add((Object)node.getSourceJoinSymbol());
            if (node.getSourceHashSymbol().isPresent()) {
                sourceInputsBuilder.add((Object)node.getSourceHashSymbol().get());
            }
            ImmutableSet sourceInputs = sourceInputsBuilder.build();
            ImmutableSet.Builder filteringSourceInputBuilder = ImmutableSet.builder();
            filteringSourceInputBuilder.add((Object)node.getFilteringSourceJoinSymbol());
            if (node.getFilteringSourceHashSymbol().isPresent()) {
                filteringSourceInputBuilder.add((Object)node.getFilteringSourceHashSymbol().get());
            }
            ImmutableSet filteringSourceInputs = filteringSourceInputBuilder.build();
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)sourceInputs);
            PlanNode filteringSource = context.rewrite(node.getFilteringSource(), (Set<Symbol>)filteringSourceInputs);
            return new SemiJoinNode(node.getId(), source, filteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder probeInputsBuilder = ImmutableSet.builder();
            probeInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getProbe));
            if (node.getProbeHashSymbol().isPresent()) {
                probeInputsBuilder.add((Object)node.getProbeHashSymbol().get());
            }
            ImmutableSet probeInputs = probeInputsBuilder.build();
            ImmutableSet.Builder indexInputBuilder = ImmutableSet.builder();
            indexInputBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getIndex));
            if (node.getIndexHashSymbol().isPresent()) {
                indexInputBuilder.add((Object)node.getIndexHashSymbol().get());
            }
            ImmutableSet indexInputs = indexInputBuilder.build();
            PlanNode probeSource = context.rewrite(node.getProbeSource(), (Set<Symbol>)probeInputs);
            PlanNode indexSource = context.rewrite(node.getIndexSource(), (Set<Symbol>)indexInputs);
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, node.getCriteria(), node.getProbeHashSymbol(), node.getIndexHashSymbol());
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            List newOutputSymbols = (List)node.getOutputSymbols().stream().filter(context.get()::contains).collect(ImmutableCollectors.toImmutableList());
            Set newLookupSymbols = (Set)node.getLookupSymbols().stream().filter(context.get()::contains).collect(ImmutableCollectors.toImmutableSet());
            Sets.SetView requiredAssignmentSymbols = context.get();
            if (!node.getEffectiveTupleDomain().isNone()) {
                Set requiredSymbols = Maps.filterValues(node.getAssignments(), (Predicate)Predicates.in(((Map)node.getEffectiveTupleDomain().getDomains().get()).keySet())).keySet();
                requiredAssignmentSymbols = Sets.union(context.get(), requiredSymbols);
            }
            Map newAssignments = Maps.filterKeys(node.getAssignments(), (Predicate)Predicates.in(requiredAssignmentSymbols));
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), newLookupSymbols, newOutputSymbols, newAssignments, node.getEffectiveTupleDomain());
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getGroupBy());
            if (node.getHashSymbol().isPresent()) {
                expectedInputs.add((Object)node.getHashSymbol().get());
            }
            ImmutableMap.Builder functions = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            ImmutableMap.Builder masks = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                if (!context.get().contains(symbol)) continue;
                FunctionCall call = entry.getValue();
                expectedInputs.addAll(DependencyExtractor.extractUnique((Expression)call));
                if (node.getMasks().containsKey(symbol)) {
                    expectedInputs.add((Object)node.getMasks().get(symbol));
                    masks.put((Object)symbol, (Object)node.getMasks().get(symbol));
                }
                functionCalls.put((Object)symbol, (Object)call);
                functions.put((Object)symbol, (Object)node.getFunctions().get(symbol));
            }
            if (node.getSampleWeight().isPresent()) {
                expectedInputs.add((Object)node.getSampleWeight().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new AggregationNode(node.getId(), source, node.getGroupBy(), (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functions.build(), (Map<Symbol, Symbol>)masks.build(), node.getGroupingSets(), node.getStep(), node.getSampleWeight(), node.getConfidence(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll(node.getPartitionBy()).addAll(node.getOrderBy());
            if (node.getFrame().getStartValue().isPresent()) {
                expectedInputs.add((Object)node.getFrame().getStartValue().get());
            }
            if (node.getFrame().getEndValue().isPresent()) {
                expectedInputs.add((Object)node.getFrame().getEndValue().get());
            }
            if (node.getHashSymbol().isPresent()) {
                expectedInputs.add((Object)node.getHashSymbol().get());
            }
            ImmutableMap.Builder functions = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                Symbol symbol = entry.getKey();
                if (!context.get().contains(symbol)) continue;
                FunctionCall call = entry.getValue();
                expectedInputs.addAll(DependencyExtractor.extractUnique((Expression)call));
                functionCalls.put((Object)symbol, (Object)call);
                functions.put((Object)symbol, (Object)node.getSignatures().get(symbol));
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new WindowNode(node.getId(), source, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getFrame(), (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functions.build(), node.getHashSymbol(), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            Set requiredTableScanOutputs = (Set)context.get().stream().filter(node.getOutputSymbols()::contains).collect(ImmutableCollectors.toImmutableSet());
            List newOutputSymbols = (List)node.getOutputSymbols().stream().filter(requiredTableScanOutputs::contains).collect(ImmutableCollectors.toImmutableList());
            Map newAssignments = Maps.filterKeys(node.getAssignments(), (Predicate)Predicates.in((Collection)requiredTableScanOutputs));
            return new TableScanNode(node.getId(), node.getTable(), newOutputSymbols, newAssignments, node.getLayout(), node.getCurrentConstraint(), node.getOriginalConstraint());
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet expectedInputs = ImmutableSet.builder().addAll(DependencyExtractor.extractUnique(node.getPredicate())).addAll((Iterable)context.get()).build();
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new FilterNode(node.getId(), source, node.getPredicate());
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            Preconditions.checkState((boolean)node.getDistinctGroupingColumns().stream().allMatch(column -> ((Set)context.get()).contains(column)));
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)ImmutableSet.copyOf((Collection)context.get()));
            List requiredSymbols = (List)context.get().stream().filter(symbol -> !symbol.equals(node.getGroupIdSymbol())).collect(ImmutableCollectors.toImmutableList());
            return new GroupIdNode(node.getId(), source, requiredSymbols, node.getGroupingSets(), node.getGroupIdSymbol());
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            if (!context.get().contains(node.getMarkerSymbol())) {
                return context.rewrite(node.getSource(), context.get());
            }
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getDistinctSymbols()).addAll((Iterable)context.get().stream().filter(symbol -> !symbol.equals(node.getMarkerSymbol())).collect(ImmutableCollectors.toImmutableList()));
            if (node.getHashSymbol().isPresent()) {
                expectedInputs.add((Object)node.getHashSymbol().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new MarkDistinctNode(node.getId(), source, node.getMarkerSymbol(), node.getDistinctSymbols(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            List replicateSymbols = (List)node.getReplicateSymbols().stream().filter(context.get()::contains).collect(ImmutableCollectors.toImmutableList());
            Optional<Symbol> ordinalitySymbol = node.getOrdinalitySymbol();
            if (ordinalitySymbol.isPresent() && !context.get().contains(ordinalitySymbol.get())) {
                ordinalitySymbol = Optional.empty();
            }
            Map<Symbol, List<Symbol>> unnestSymbols = node.getUnnestSymbols();
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)replicateSymbols).addAll(unnestSymbols.keySet());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new UnnestNode(node.getId(), source, replicateSymbols, unnestSymbols, ordinalitySymbol);
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol output = node.getOutputSymbols().get(i);
                Expression expression = node.getAssignments().get(output);
                if (!context.get().contains(output)) continue;
                expectedInputs.addAll(DependencyExtractor.extractUnique(expression));
                builder.put((Object)output, (Object)expression);
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new ProjectNode(node.getId(), source, (Map<Symbol, Expression>)builder.build());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet expectedInputs = ImmutableSet.copyOf(node.getOutputSymbols());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new OutputNode(node.getId(), source, node.getColumnNames(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new LimitNode(node.getId(), source, node.getCount());
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet expectedInputs = node.getHashSymbol().isPresent() ? ImmutableSet.copyOf((Iterable)Iterables.concat(node.getOutputSymbols(), (Iterable)ImmutableList.of((Object)node.getHashSymbol().get()))) : ImmutableSet.copyOf(node.getOutputSymbols());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new DistinctLimitNode(node.getId(), source, node.getLimit(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll(node.getOrderBy());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TopNNode(node.getId(), source, node.getCount(), node.getOrderBy(), node.getOrderings(), node.isPartial());
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder inputsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder expectedInputs = inputsBuilder.addAll((Iterable)context.get()).addAll(node.getPartitionBy());
            if (node.getHashSymbol().isPresent()) {
                inputsBuilder.add((Object)node.getHashSymbol().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new RowNumberNode(node.getId(), source, node.getPartitionBy(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll(node.getPartitionBy()).addAll(node.getOrderBy());
            if (node.getHashSymbol().isPresent()) {
                expectedInputs.add((Object)node.getHashSymbol().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TopNRowNumberNode(node.getId(), source, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.isPartial(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet expectedInputs = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)context.get(), node.getOrderBy()));
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new SortNode(node.getId(), source, node.getOrderBy(), node.getOrderings());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getColumns());
            if (node.getSampleWeightSymbol().isPresent()) {
                expectedInputs.add((Object)node.getSampleWeightSymbol().get());
            }
            if (node.getPartitionFunction().isPresent()) {
                PartitionFunctionBinding functionBinding = node.getPartitionFunction().get();
                functionBinding.getPartitionFunctionArguments().stream().filter(PartitionFunctionBinding.PartitionFunctionArgumentBinding::isVariable).map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::getColumn).forEach(arg_0 -> ((ImmutableSet.Builder)expectedInputs).add(arg_0));
                functionBinding.getHashColumn().ifPresent(arg_0 -> ((ImmutableSet.Builder)expectedInputs).add(arg_0));
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TableWriterNode(node.getId(), source, node.getTarget(), node.getColumns(), node.getColumnNames(), node.getOutputSymbols(), node.getSampleWeightSymbol(), node.getPartitionFunction());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)ImmutableSet.copyOf(node.getSource().getOutputSymbols()));
            return new TableFinishNode(node.getId(), source, node.getTarget(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)ImmutableSet.of((Object)node.getRowId()));
            return new DeleteNode(node.getId(), source, node.getTarget(), node.getRowId(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableListMultimap.Builder rewrittenSymbolMappingBuilder = ImmutableListMultimap.builder();
            for (Symbol symbol : node.getOutputSymbols()) {
                if (!context.get().contains(symbol)) continue;
                rewrittenSymbolMappingBuilder.putAll((Object)symbol, (Iterable)node.getSymbolMapping().get((Object)symbol));
            }
            ImmutableListMultimap rewrittenSymbolMapping = rewrittenSymbolMappingBuilder.build();
            ImmutableList.Builder rewrittenSubPlans = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                ImmutableSet.Builder expectedInputSymbols = ImmutableSet.builder();
                for (Collection symbols : rewrittenSymbolMapping.asMap().values()) {
                    expectedInputSymbols.add(Iterables.get((Iterable)symbols, (int)i));
                }
                rewrittenSubPlans.add((Object)context.rewrite(node.getSources().get(i), (Set<Symbol>)expectedInputSymbols.build()));
            }
            return new UnionNode(node.getId(), (List<PlanNode>)rewrittenSubPlans.build(), (ListMultimap<Symbol, Symbol>)rewrittenSymbolMapping, (List<Symbol>)ImmutableList.copyOf((Collection)rewrittenSymbolMapping.keySet()));
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableList.Builder rewrittenOutputSymbolsBuilder = ImmutableList.builder();
            ImmutableList.Builder rowBuildersBuilder = ImmutableList.builder();
            for (int i = 0; i < node.getRows().size(); ++i) {
                rowBuildersBuilder.add((Object)ImmutableList.builder());
            }
            ImmutableList rowBuilders = rowBuildersBuilder.build();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol outputSymbol = node.getOutputSymbols().get(i);
                if (!context.get().contains(outputSymbol)) continue;
                rewrittenOutputSymbolsBuilder.add((Object)outputSymbol);
                for (int j = 0; j < node.getRows().size(); ++j) {
                    ((ImmutableList.Builder)rowBuilders.get(j)).add((Object)node.getRows().get(j).get(i));
                }
            }
            List rewrittenRows = (List)rowBuilders.stream().map(rowBuilder -> rowBuilder.build()).collect(ImmutableCollectors.toImmutableList());
            return new ValuesNode(node.getId(), (List<Symbol>)rewrittenOutputSymbolsBuilder.build(), rewrittenRows);
        }
    }
}

