/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class UnaliasSymbolReferences
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Map<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>();

        private Rewriter() {
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder functionInfos = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            ImmutableMap.Builder masks = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                Symbol canonical = this.canonicalize(symbol);
                FunctionCall canonicalCall = (FunctionCall)this.canonicalize((Expression)entry.getValue());
                functionCalls.put((Object)canonical, (Object)canonicalCall);
                functionInfos.put((Object)canonical, (Object)node.getFunctions().get(symbol));
            }
            for (Map.Entry<Symbol, Object> entry : node.getMasks().entrySet()) {
                masks.put((Object)this.canonicalize(entry.getKey()), (Object)this.canonicalize((Symbol)entry.getValue()));
            }
            List<Symbol> groupByKeys = this.canonicalizeAndDistinct(node.getGroupBy());
            List list = (List)node.getGroupingSets().stream().map(this::canonicalizeAndDistinct).collect(ImmutableCollectors.toImmutableList());
            return new AggregationNode(node.getId(), source, groupByKeys, (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functionInfos.build(), (Map<Symbol, Symbol>)masks.build(), list, node.getStep(), this.canonicalize(node.getSampleWeight()), node.getConfidence(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List<List<Symbol>> groupingSetsSymbols = node.getGroupingSets().stream().map(this::canonicalize).collect(Collectors.toList());
            return new GroupIdNode(node.getId(), source, this.canonicalize(node.getInputSymbols()), groupingSetsSymbols, this.canonicalize(node.getGroupIdSymbol()));
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new ExplainAnalyzeNode(node.getId(), source, this.canonicalize(node.getOutputSymbol()));
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List<Symbol> symbols = this.canonicalizeAndDistinct(node.getDistinctSymbols());
            return new MarkDistinctNode(node.getId(), source, this.canonicalize(node.getMarkerSymbol()), symbols, this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Symbol, List<Symbol>> entry : node.getUnnestSymbols().entrySet()) {
                builder.put((Object)this.canonicalize(entry.getKey()), entry.getValue());
            }
            return new UnnestNode(node.getId(), source, this.canonicalizeAndDistinct(node.getReplicateSymbols()), (Map<Symbol, List<Symbol>>)builder.build(), node.getOrdinalitySymbol());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder functionInfos = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                Symbol symbol = entry.getKey();
                Symbol canonical = this.canonicalize(symbol);
                functionCalls.put((Object)canonical, (Object)((FunctionCall)this.canonicalize((Expression)entry.getValue())));
                functionInfos.put((Object)canonical, (Object)node.getSignatures().get(symbol));
            }
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Map.Entry<Symbol, SortOrder> entry : node.getOrderings().entrySet()) {
                orderings.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            WindowNode.Frame frame2 = node.getFrame();
            frame2 = new WindowNode.Frame(frame2.getType(), frame2.getStartType(), this.canonicalize(frame2.getStartValue()), frame2.getEndType(), this.canonicalize(frame2.getEndValue()));
            return new WindowNode(node.getId(), source, this.canonicalizeAndDistinct(node.getPartitionBy()), this.canonicalizeAndDistinct(node.getOrderBy()), (Map<Symbol, SortOrder>)orderings.build(), frame2, (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functionInfos.build(), this.canonicalize(node.getHashSymbol()), this.canonicalize(node.getPrePartitionedInputs()), node.getPreSortedOrderPrefix());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Expression originalConstraint = null;
            if (node.getOriginalConstraint() != null) {
                originalConstraint = this.canonicalize(node.getOriginalConstraint());
            }
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), node.getLayout(), node.getCurrentConstraint(), originalConstraint);
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List sources = (List)node.getSources().stream().map(context::rewrite).collect(ImmutableCollectors.toImmutableList());
            ArrayList<List<Symbol>> inputs = new ArrayList<List<Symbol>>();
            for (int i = 0; i < node.getInputs().size(); ++i) {
                inputs.add(new ArrayList());
            }
            HashSet<Symbol> addedOutputs = new HashSet<Symbol>();
            ImmutableList.Builder outputs = ImmutableList.builder();
            for (int symbolIndex = 0; symbolIndex < node.getOutputSymbols().size(); ++symbolIndex) {
                Symbol canonicalOutput = this.canonicalize(node.getOutputSymbols().get(symbolIndex));
                if (!addedOutputs.add(canonicalOutput)) continue;
                outputs.add((Object)canonicalOutput);
                for (int i = 0; i < node.getInputs().size(); ++i) {
                    List<Symbol> input = node.getInputs().get(i);
                    ((List)inputs.get(i)).add(this.canonicalize(input.get(symbolIndex)));
                }
            }
            PartitionFunctionBinding partitionFunction = new PartitionFunctionBinding(node.getPartitionFunction().getPartitioningHandle(), (List<Symbol>)outputs.build(), this.canonicalizePartitionFunctionArgument(node.getPartitionFunction().getPartitionFunctionArguments()), this.canonicalize(node.getPartitionFunction().getHashColumn()), node.getPartitionFunction().isReplicateNulls(), node.getPartitionFunction().getBucketToPartition());
            return new ExchangeNode(node.getId(), node.getType(), partitionFunction, sources, inputs);
        }

        @Override
        public PlanNode visitRemoteSource(RemoteSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RemoteSourceNode(node.getId(), node.getSourceFragmentIds(), this.canonicalizeAndDistinct(node.getOutputSymbols()));
        }

        @Override
        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DistinctLimitNode(node.getId(), context.rewrite(node.getSource()), node.getLimit(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new SampleNode(node.getId(), context.rewrite(node.getSource()), node.getSampleRatio(), node.getSampleType(), node.isRescaled(), this.canonicalize(node.getSampleWeightSymbol()));
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DeleteNode(node.getId(), context.rewrite(node.getSource()), node.getTarget(), this.canonicalize(node.getRowId()), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RowNumberNode(node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getPartitionBy()), this.canonicalize(node.getRowNumberSymbol()), node.getMaxRowCountPerPartition(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
            for (Symbol symbol : node.getOrderings().keySet()) {
                orderings.put(this.canonicalize(symbol), node.getOrderings().get(symbol));
            }
            return new TopNRowNumberNode(node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getPartitionBy()), this.canonicalizeAndDistinct(node.getOrderBy()), orderings, this.canonicalize(node.getRowNumberSymbol()), node.getMaxRowCountPerPartition(), node.isPartial(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new FilterNode(node.getId(), source, this.canonicalize(node.getPredicate()));
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            HashMap<Expression, Symbol> computedExpressions = new HashMap<Expression, Symbol>();
            LinkedHashMap<Symbol, Expression> assignments = new LinkedHashMap<Symbol, Expression>();
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                Symbol canonical;
                Expression expression = this.canonicalize(entry.getValue());
                if (expression instanceof QualifiedNameReference) {
                    Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
                    if (!symbol.equals(entry.getKey())) {
                        this.map(entry.getKey(), symbol);
                    }
                } else if (DeterminismEvaluator.isDeterministic(expression) && !(expression instanceof NullLiteral)) {
                    Symbol computedSymbol = (Symbol)computedExpressions.get(expression);
                    if (computedSymbol == null) {
                        computedExpressions.put(expression, entry.getKey());
                    } else {
                        this.map(entry.getKey(), computedSymbol);
                    }
                }
                if (assignments.containsKey(canonical = this.canonicalize(entry.getKey()))) continue;
                assignments.put(canonical, expression);
            }
            return new ProjectNode(node.getId(), source, assignments);
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List canonical = Lists.transform(node.getOutputSymbols(), this::canonicalize);
            return new OutputNode(node.getId(), source, node.getColumnNames(), canonical);
        }

        @Override
        public PlanNode visitEnforceSingleRow(EnforceSingleRowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new EnforceSingleRowNode(node.getId(), source);
        }

        @Override
        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : node.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
            }
            return new TopNNode(node.getId(), source, node.getCount(), (List<Symbol>)symbols.build(), (Map<Symbol, SortOrder>)orderings.build(), node.isPartial());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : node.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
            }
            return new SortNode(node.getId(), source, (List<Symbol>)symbols.build(), (Map<Symbol, SortOrder>)orderings.build());
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = context.rewrite(node.getLeft());
            PlanNode right = context.rewrite(node.getRight());
            return new JoinNode(node.getId(), node.getType(), left, right, this.canonicalizeJoinCriteria(node.getCriteria()), this.canonicalize(node.getLeftHashSymbol()), this.canonicalize(node.getRightHashSymbol()));
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            PlanNode filteringSource = context.rewrite(node.getFilteringSource());
            return new SemiJoinNode(node.getId(), source, filteringSource, this.canonicalize(node.getSourceJoinSymbol()), this.canonicalize(node.getFilteringSourceJoinSymbol()), this.canonicalize(node.getSemiJoinOutput()), this.canonicalize(node.getSourceHashSymbol()), this.canonicalize(node.getFilteringSourceHashSymbol()));
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), this.canonicalize(node.getLookupSymbols()), node.getOutputSymbols(), node.getAssignments(), node.getEffectiveTupleDomain());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode probeSource = context.rewrite(node.getProbeSource());
            PlanNode indexSource = context.rewrite(node.getIndexSource());
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, this.canonicalizeIndexJoinCriteria(node.getCriteria()), this.canonicalize(node.getProbeHashSymbol()), this.canonicalize(node.getIndexHashSymbol()));
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                rewrittenSources.add((Object)context.rewrite(source));
            }
            return new UnionNode(node.getId(), (List<PlanNode>)rewrittenSources.build(), this.canonicalizeUnionSymbolMap(node.getSymbolMapping()), this.canonicalize(node.getOutputSymbols()));
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableList columns = node.getColumns().stream().map(this::canonicalize).collect(ImmutableCollectors.toImmutableList());
            return new TableWriterNode(node.getId(), source, node.getTarget(), (List<Symbol>)columns, node.getColumnNames(), node.getOutputSymbols(), this.canonicalize(node.getSampleWeightSymbol()), node.getPartitionFunction().map(this::canonicalizePartitionFunctionBinding));
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            throw new UnsupportedOperationException("Unsupported plan node " + node.getClass().getSimpleName());
        }

        private void map(Symbol symbol, Symbol canonical) {
            Preconditions.checkArgument((!symbol.equals(canonical) ? 1 : 0) != 0, (String)"Can't map symbol to itself: %s", (Object[])new Object[]{symbol});
            this.mapping.put(symbol, canonical);
        }

        private Optional<Symbol> canonicalize(Optional<Symbol> symbol) {
            if (symbol.isPresent()) {
                return Optional.of(this.canonicalize(symbol.get()));
            }
            return Optional.empty();
        }

        private Symbol canonicalize(Symbol symbol) {
            Symbol canonical = symbol;
            while (this.mapping.containsKey(canonical)) {
                canonical = this.mapping.get(canonical);
            }
            return canonical;
        }

        private Expression canonicalize(Expression value) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Symbol canonical = this.canonicalize(Symbol.fromQualifiedName(node.getName()));
                    return new QualifiedNameReference(canonical.toQualifiedName());
                }
            }, (Expression)value);
        }

        private List<Symbol> canonicalizeAndDistinct(List<Symbol> outputs) {
            HashSet<Symbol> added = new HashSet<Symbol>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Symbol symbol : outputs) {
                Symbol canonical = this.canonicalize(symbol);
                if (!added.add(canonical)) continue;
                builder.add((Object)canonical);
            }
            return builder.build();
        }

        private List<Symbol> canonicalize(List<Symbol> symbols) {
            return (List)symbols.stream().map(this::canonicalize).collect(ImmutableCollectors.toImmutableList());
        }

        private Set<Symbol> canonicalize(Set<Symbol> symbols) {
            return (Set)symbols.stream().map(this::canonicalize).collect(ImmutableCollectors.toImmutableSet());
        }

        private List<PartitionFunctionBinding.PartitionFunctionArgumentBinding> canonicalizePartitionFunctionArgument(List<PartitionFunctionBinding.PartitionFunctionArgumentBinding> arguments) {
            return (List)arguments.stream().map(argument -> argument.isConstant() ? argument : new PartitionFunctionBinding.PartitionFunctionArgumentBinding(this.canonicalize(argument.getColumn()))).collect(ImmutableCollectors.toImmutableList());
        }

        private List<JoinNode.EquiJoinClause> canonicalizeJoinCriteria(List<JoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new JoinNode.EquiJoinClause(this.canonicalize(clause.getLeft()), this.canonicalize(clause.getRight())));
            }
            return builder.build();
        }

        private List<IndexJoinNode.EquiJoinClause> canonicalizeIndexJoinCriteria(List<IndexJoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexJoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(this.canonicalize(clause.getProbe()), this.canonicalize(clause.getIndex())));
            }
            return builder.build();
        }

        private ListMultimap<Symbol, Symbol> canonicalizeUnionSymbolMap(ListMultimap<Symbol, Symbol> unionSymbolMap) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (Map.Entry entry : unionSymbolMap.asMap().entrySet()) {
                builder.putAll((Object)this.canonicalize((Symbol)entry.getKey()), Iterables.transform((Iterable)((Iterable)entry.getValue()), this::canonicalize));
            }
            return builder.build();
        }

        private PartitionFunctionBinding canonicalizePartitionFunctionBinding(PartitionFunctionBinding function) {
            return new PartitionFunctionBinding(function.getPartitioningHandle(), this.canonicalize(function.getOutputLayout()), this.canonicalizePartitionFunctionArgument(function.getPartitionFunctionArguments()), this.canonicalize(function.getHashColumn()), function.isReplicateNulls(), function.getBucketToPartition());
        }
    }
}

