/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SemiJoinNode
extends PlanNode {
    private final PlanNode source;
    private final PlanNode filteringSource;
    private final Symbol sourceJoinSymbol;
    private final Symbol filteringSourceJoinSymbol;
    private final Symbol semiJoinOutput;
    private final Optional<Symbol> sourceHashSymbol;
    private final Optional<Symbol> filteringSourceHashSymbol;

    @JsonCreator
    public SemiJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="filteringSource") PlanNode filteringSource, @JsonProperty(value="sourceJoinSymbol") Symbol sourceJoinSymbol, @JsonProperty(value="filteringSourceJoinSymbol") Symbol filteringSourceJoinSymbol, @JsonProperty(value="semiJoinOutput") Symbol semiJoinOutput, @JsonProperty(value="sourceHashSymbol") Optional<Symbol> sourceHashSymbol, @JsonProperty(value="filteringSourceHashSymbol") Optional<Symbol> filteringSourceHashSymbol) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.filteringSource = Objects.requireNonNull(filteringSource, "filteringSource is null");
        this.sourceJoinSymbol = Objects.requireNonNull(sourceJoinSymbol, "sourceJoinSymbol is null");
        this.filteringSourceJoinSymbol = Objects.requireNonNull(filteringSourceJoinSymbol, "filteringSourceJoinSymbol is null");
        this.semiJoinOutput = Objects.requireNonNull(semiJoinOutput, "semiJoinOutput is null");
        this.sourceHashSymbol = Objects.requireNonNull(sourceHashSymbol, "sourceHashSymbol is null");
        this.filteringSourceHashSymbol = Objects.requireNonNull(filteringSourceHashSymbol, "filteringSourceHashSymbol is null");
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="filteringSource")
    public PlanNode getFilteringSource() {
        return this.filteringSource;
    }

    @JsonProperty(value="sourceJoinSymbol")
    public Symbol getSourceJoinSymbol() {
        return this.sourceJoinSymbol;
    }

    @JsonProperty(value="filteringSourceJoinSymbol")
    public Symbol getFilteringSourceJoinSymbol() {
        return this.filteringSourceJoinSymbol;
    }

    @JsonProperty(value="semiJoinOutput")
    public Symbol getSemiJoinOutput() {
        return this.semiJoinOutput;
    }

    @JsonProperty(value="sourceHashSymbol")
    public Optional<Symbol> getSourceHashSymbol() {
        return this.sourceHashSymbol;
    }

    @JsonProperty(value="filteringSourceHashSymbol")
    public Optional<Symbol> getFilteringSourceHashSymbol() {
        return this.filteringSourceHashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source, (Object)this.filteringSource);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.semiJoinOutput).build();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitSemiJoin(this, context);
    }
}

