/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import java.util.Objects;

public class DeterminismEvaluator {
    final FunctionRegistry registry;

    public DeterminismEvaluator(FunctionRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
    }

    public boolean isDeterministic(RowExpression expression) {
        return expression.accept(new Visitor(this.registry), null);
    }

    private static class Visitor
    implements RowExpressionVisitor<Void, Boolean> {
        private final FunctionRegistry registry;

        public Visitor(FunctionRegistry registry) {
            this.registry = registry;
        }

        @Override
        public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
            return true;
        }

        @Override
        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return true;
        }

        @Override
        public Boolean visitCall(CallExpression call, Void context) {
            Signature signature = call.getSignature();
            if (this.registry.isRegistered(signature) && !this.registry.getScalarFunctionImplementation(signature).isDeterministic()) {
                return false;
            }
            return call.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }
    }
}

